@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.ResourceSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Microsoft.Elastic SKU.
 * @property name Name of the SKU.
 */
public data class ResourceSkuArgs(
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.ResourceSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.ResourceSkuArgs =
        com.pulumi.azurenative.elastic.inputs.ResourceSkuArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceSkuArgs].
 */
@PulumiTagMarker
public class ResourceSkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the SKU.
     */
    @JvmName("vyvxsacvkuvcthql")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the SKU.
     */
    @JvmName("aypkmrgkoqqfvfdj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ResourceSkuArgs = ResourceSkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
