@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Monitor resource.
 * @property id ARM id of the monitor resource.
 * @property identity Identity properties of the monitor resource.
 * @property location The location of the monitor resource
 * @property name Name of the monitor resource.
 * @property properties Properties of the monitor resource.
 * @property sku SKU of the monitor resource.
 * @property systemData The system metadata relating to this resource
 * @property tags The tags of the monitor resource.
 * @property type The type of the monitor resource.
 */
public data class GetMonitorResult(
    public val id: String,
    public val identity: IdentityPropertiesResponse? = null,
    public val location: String,
    public val name: String,
    public val properties: MonitorPropertiesResponse,
    public val sku: ResourceSkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.GetMonitorResult):
            GetMonitorResult = GetMonitorResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.elastic.kotlin.outputs.MonitorPropertiesResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.elastic.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
