@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin

import com.pulumi.azurenative.elasticsan.ElasticsanFunctions.getElasticSanPlain
import com.pulumi.azurenative.elasticsan.ElasticsanFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.elasticsan.ElasticsanFunctions.getVolumeGroupPlain
import com.pulumi.azurenative.elasticsan.ElasticsanFunctions.getVolumePlain
import com.pulumi.azurenative.elasticsan.ElasticsanFunctions.getVolumeSnapshotPlain
import com.pulumi.azurenative.elasticsan.kotlin.inputs.GetElasticSanPlainArgs
import com.pulumi.azurenative.elasticsan.kotlin.inputs.GetElasticSanPlainArgsBuilder
import com.pulumi.azurenative.elasticsan.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.elasticsan.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.elasticsan.kotlin.inputs.GetVolumeGroupPlainArgs
import com.pulumi.azurenative.elasticsan.kotlin.inputs.GetVolumeGroupPlainArgsBuilder
import com.pulumi.azurenative.elasticsan.kotlin.inputs.GetVolumePlainArgs
import com.pulumi.azurenative.elasticsan.kotlin.inputs.GetVolumePlainArgsBuilder
import com.pulumi.azurenative.elasticsan.kotlin.inputs.GetVolumeSnapshotPlainArgs
import com.pulumi.azurenative.elasticsan.kotlin.inputs.GetVolumeSnapshotPlainArgsBuilder
import com.pulumi.azurenative.elasticsan.kotlin.outputs.GetElasticSanResult
import com.pulumi.azurenative.elasticsan.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.elasticsan.kotlin.outputs.GetVolumeGroupResult
import com.pulumi.azurenative.elasticsan.kotlin.outputs.GetVolumeResult
import com.pulumi.azurenative.elasticsan.kotlin.outputs.GetVolumeSnapshotResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.elasticsan.kotlin.outputs.GetElasticSanResult.Companion.toKotlin as getElasticSanResultToKotlin
import com.pulumi.azurenative.elasticsan.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.elasticsan.kotlin.outputs.GetVolumeGroupResult.Companion.toKotlin as getVolumeGroupResultToKotlin
import com.pulumi.azurenative.elasticsan.kotlin.outputs.GetVolumeResult.Companion.toKotlin as getVolumeResultToKotlin
import com.pulumi.azurenative.elasticsan.kotlin.outputs.GetVolumeSnapshotResult.Companion.toKotlin as getVolumeSnapshotResultToKotlin

public object ElasticsanFunctions {
    /**
     * Get a ElasticSan.
     * Azure REST API version: 2021-11-20-preview.
     * Other available API versions: 2022-12-01-preview, 2023-01-01.
     * @param argument null
     * @return Response for ElasticSan request.
     */
    public suspend fun getElasticSan(argument: GetElasticSanPlainArgs): GetElasticSanResult =
        getElasticSanResultToKotlin(getElasticSanPlain(argument.toJava()).await())

    /**
     * @see [getElasticSan].
     * @param elasticSanName The name of the ElasticSan.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for ElasticSan request.
     */
    public suspend fun getElasticSan(elasticSanName: String, resourceGroupName: String):
        GetElasticSanResult {
        val argument = GetElasticSanPlainArgs(
            elasticSanName = elasticSanName,
            resourceGroupName = resourceGroupName,
        )
        return getElasticSanResultToKotlin(getElasticSanPlain(argument.toJava()).await())
    }

    /**
     * @see [getElasticSan].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elasticsan&#46;kotlin&#46;inputs&#46;GetElasticSanPlainArgs].
     * @return Response for ElasticSan request.
     */
    public suspend fun getElasticSan(argument: suspend GetElasticSanPlainArgsBuilder.() -> Unit):
        GetElasticSanResult {
        val builder = GetElasticSanPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getElasticSanResultToKotlin(getElasticSanPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the Elastic San
     * Azure REST API version: 2022-12-01-preview.
     * Other available API versions: 2023-01-01.
     * @param argument null
     * @return Response for PrivateEndpoint Connection object
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param elasticSanName The name of the ElasticSan.
     * @param privateEndpointConnectionName The name of the Private Endpoint connection.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for PrivateEndpoint Connection object
     */
    public suspend fun getPrivateEndpointConnection(
        elasticSanName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            elasticSanName = elasticSanName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elasticsan&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return Response for PrivateEndpoint Connection object
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an Volume.
     * Azure REST API version: 2021-11-20-preview.
     * Other available API versions: 2022-12-01-preview, 2023-01-01.
     * @param argument null
     * @return Response for Volume request.
     */
    public suspend fun getVolume(argument: GetVolumePlainArgs): GetVolumeResult =
        getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())

    /**
     * @see [getVolume].
     * @param elasticSanName The name of the ElasticSan.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param volumeGroupName The name of the VolumeGroup.
     * @param volumeName The name of the Volume.
     * @return Response for Volume request.
     */
    public suspend fun getVolume(
        elasticSanName: String,
        resourceGroupName: String,
        volumeGroupName: String,
        volumeName: String,
    ): GetVolumeResult {
        val argument = GetVolumePlainArgs(
            elasticSanName = elasticSanName,
            resourceGroupName = resourceGroupName,
            volumeGroupName = volumeGroupName,
            volumeName = volumeName,
        )
        return getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())
    }

    /**
     * @see [getVolume].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elasticsan&#46;kotlin&#46;inputs&#46;GetVolumePlainArgs].
     * @return Response for Volume request.
     */
    public suspend fun getVolume(argument: suspend GetVolumePlainArgsBuilder.() -> Unit):
        GetVolumeResult {
        val builder = GetVolumePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeResultToKotlin(getVolumePlain(builtArgument.toJava()).await())
    }

    /**
     * Get an VolumeGroups.
     * Azure REST API version: 2021-11-20-preview.
     * Other available API versions: 2022-12-01-preview, 2023-01-01.
     * @param argument null
     * @return Response for Volume Group request.
     */
    public suspend fun getVolumeGroup(argument: GetVolumeGroupPlainArgs): GetVolumeGroupResult =
        getVolumeGroupResultToKotlin(getVolumeGroupPlain(argument.toJava()).await())

    /**
     * @see [getVolumeGroup].
     * @param elasticSanName The name of the ElasticSan.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param volumeGroupName The name of the VolumeGroup.
     * @return Response for Volume Group request.
     */
    public suspend fun getVolumeGroup(
        elasticSanName: String,
        resourceGroupName: String,
        volumeGroupName: String,
    ): GetVolumeGroupResult {
        val argument = GetVolumeGroupPlainArgs(
            elasticSanName = elasticSanName,
            resourceGroupName = resourceGroupName,
            volumeGroupName = volumeGroupName,
        )
        return getVolumeGroupResultToKotlin(getVolumeGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getVolumeGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elasticsan&#46;kotlin&#46;inputs&#46;GetVolumeGroupPlainArgs].
     * @return Response for Volume Group request.
     */
    public suspend fun getVolumeGroup(argument: suspend GetVolumeGroupPlainArgsBuilder.() -> Unit):
        GetVolumeGroupResult {
        val builder = GetVolumeGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeGroupResultToKotlin(getVolumeGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Volume Snapshot.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return Response for Volume Snapshot request.
     */
    public suspend fun getVolumeSnapshot(argument: GetVolumeSnapshotPlainArgs):
        GetVolumeSnapshotResult =
        getVolumeSnapshotResultToKotlin(getVolumeSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getVolumeSnapshot].
     * @param elasticSanName The name of the ElasticSan.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param snapshotName The name of the volume snapshot within the given volume group.
     * @param volumeGroupName The name of the VolumeGroup.
     * @return Response for Volume Snapshot request.
     */
    public suspend fun getVolumeSnapshot(
        elasticSanName: String,
        resourceGroupName: String,
        snapshotName: String,
        volumeGroupName: String,
    ): GetVolumeSnapshotResult {
        val argument = GetVolumeSnapshotPlainArgs(
            elasticSanName = elasticSanName,
            resourceGroupName = resourceGroupName,
            snapshotName = snapshotName,
            volumeGroupName = volumeGroupName,
        )
        return getVolumeSnapshotResultToKotlin(getVolumeSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getVolumeSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;elasticsan&#46;kotlin&#46;inputs&#46;GetVolumeSnapshotPlainArgs].
     * @return Response for Volume Snapshot request.
     */
    public suspend
    fun getVolumeSnapshot(argument: suspend GetVolumeSnapshotPlainArgsBuilder.() -> Unit):
        GetVolumeSnapshotResult {
        val builder = GetVolumeSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeSnapshotResultToKotlin(getVolumeSnapshotPlain(builtArgument.toJava()).await())
    }
}
