@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin

import com.pulumi.azurenative.elasticsan.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.elasticsan.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.elasticsan.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *  Response for PrivateEndpoint Connection object
 * Azure REST API version: 2022-12-01-preview.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### PrivateEndpointConnections_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.ElasticSan.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         ElasticSanName = "elasticsanname",
 *         GroupIds = new[]
 *         {
 *             "sytxzqlcoapcaywthgwvwcw",
 *         },
 *         PrivateEndpointConnectionName = "privateendpointconnectionname",
 *         PrivateLinkServiceConnectionState = new AzureNative.ElasticSan.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Description = "Auto-Approved",
 *             Status = "Pending",
 *         },
 *         ResourceGroupName = "resourcegroupname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &elasticsan.PrivateEndpointConnectionArgs{
 * 			ElasticSanName: pulumi.String("elasticsanname"),
 * 			GroupIds: pulumi.StringArray{
 * 				pulumi.String("sytxzqlcoapcaywthgwvwcw"),
 * 			},
 * 			PrivateEndpointConnectionName: pulumi.String("privateendpointconnectionname"),
 * 			PrivateLinkServiceConnectionState: &elasticsan.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Description:     pulumi.String("Auto-Approved"),
 * 				Status:          pulumi.String("Pending"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourcegroupname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.PrivateEndpointConnection;
 * import com.pulumi.azurenative.elasticsan.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .elasticSanName("elasticsanname")
 *             .groupIds("sytxzqlcoapcaywthgwvwcw")
 *             .privateEndpointConnectionName("privateendpointconnectionname")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("actionsRequired", "None"),
 *                 Map.entry("description", "Auto-Approved"),
 *                 Map.entry("status", "Pending")
 *             ))
 *             .resourceGroupName("resourcegroupname")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateEndpointConnections_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.ElasticSan.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         ElasticSanName = "elasticsanname",
 *         PrivateEndpointConnectionName = "privateendpointconnectionname",
 *         PrivateLinkServiceConnectionState = new AzureNative.ElasticSan.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Description = "Auto-Approved",
 *             Status = "Pending",
 *         },
 *         ResourceGroupName = "resourcegroupname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &elasticsan.PrivateEndpointConnectionArgs{
 * 			ElasticSanName:                pulumi.String("elasticsanname"),
 * 			PrivateEndpointConnectionName: pulumi.String("privateendpointconnectionname"),
 * 			PrivateLinkServiceConnectionState: &elasticsan.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Description:     pulumi.String("Auto-Approved"),
 * 				Status:          pulumi.String("Pending"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourcegroupname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.PrivateEndpointConnection;
 * import com.pulumi.azurenative.elasticsan.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .elasticSanName("elasticsanname")
 *             .privateEndpointConnectionName("privateendpointconnectionname")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("actionsRequired", "None"),
 *                 Map.entry("description", "Auto-Approved"),
 *                 Map.entry("status", "Pending")
 *             ))
 *             .resourceGroupName("resourcegroupname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elasticsan:PrivateEndpointConnection {privateEndpointConnectionName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property elasticSanName The name of the ElasticSan.
 * @property groupIds  List of resources private endpoint is mapped
 * @property privateEndpointConnectionName The name of the Private Endpoint connection.
 * @property privateLinkServiceConnectionState Private Link Service Connection State.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PrivateEndpointConnectionArgs(
    public val elasticSanName: Output<String>? = null,
    public val groupIds: Output<List<String>>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.elasticsan.PrivateEndpointConnectionArgs.builder()
            .elasticSanName(elasticSanName?.applyValue({ args0 -> args0 }))
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var elasticSanName: Output<String>? = null

    private var groupIds: Output<List<String>>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("hsjeaabmslhodeej")
    public suspend fun elasticSanName(`value`: Output<String>) {
        this.elasticSanName = value
    }

    /**
     * @param value  List of resources private endpoint is mapped
     */
    @JvmName("raujysimbgwajood")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("socvwlnybaofetku")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values  List of resources private endpoint is mapped
     */
    @JvmName("wuiygscmtmxkrhym")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The name of the Private Endpoint connection.
     */
    @JvmName("sdbdhvgrhsbxkmap")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Private Link Service Connection State.
     */
    @JvmName("mdqqpfbiwirenhpo")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nsfnsenwwftxyqee")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("qsltuvtmsvlpdmkk")
    public suspend fun elasticSanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticSanName = mapped
    }

    /**
     * @param value  List of resources private endpoint is mapped
     */
    @JvmName("csyxlodqbbsodhwl")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values  List of resources private endpoint is mapped
     */
    @JvmName("eqenvvjvxiwtvskf")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The name of the Private Endpoint connection.
     */
    @JvmName("cyvwkcnqmvbcawxo")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Private Link Service Connection State.
     */
    @JvmName("nwjjedjfglsicinf")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Private Link Service Connection State.
     */
    @JvmName("xlxpgtcatpkqopfr")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("komamnubrsequjje")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        elasticSanName = elasticSanName,
        groupIds = groupIds,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
    )
}
