@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin

import com.pulumi.azurenative.elasticsan.kotlin.outputs.SnapshotCreationDataResponse
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SnapshotCreationDataResponse.Companion.toKotlin as snapshotCreationDataResponseToKotlin
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [VolumeSnapshot].
 */
@PulumiTagMarker
public class VolumeSnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VolumeSnapshotArgs = VolumeSnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VolumeSnapshotArgsBuilder.() -> Unit) {
        val builder = VolumeSnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VolumeSnapshot {
        val builtJavaResource =
            com.pulumi.azurenative.elasticsan.VolumeSnapshot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VolumeSnapshot(builtJavaResource)
    }
}

/**
 * Response for Volume Snapshot request.
 * Azure REST API version: 2023-01-01.
 * ## Example Usage
 * ### VolumeSnapshots_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeSnapshot = new AzureNative.ElasticSan.VolumeSnapshot("volumeSnapshot", new()
 *     {
 *         CreationData = new AzureNative.ElasticSan.Inputs.SnapshotCreationDataArgs
 *         {
 *             SourceId = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}",
 *         },
 *         ElasticSanName = "elasticsanname",
 *         ResourceGroupName = "resourcegroupname",
 *         SnapshotName = "snapshotname",
 *         VolumeGroupName = "volumegroupname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolumeSnapshot(ctx, "volumeSnapshot", &elasticsan.VolumeSnapshotArgs{
 * 			CreationData: &elasticsan.SnapshotCreationDataArgs{
 * 				SourceId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}"),
 * 			},
 * 			ElasticSanName:    pulumi.String("elasticsanname"),
 * 			ResourceGroupName: pulumi.String("resourcegroupname"),
 * 			SnapshotName:      pulumi.String("snapshotname"),
 * 			VolumeGroupName:   pulumi.String("volumegroupname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.VolumeSnapshot;
 * import com.pulumi.azurenative.elasticsan.VolumeSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeSnapshot = new VolumeSnapshot("volumeSnapshot", VolumeSnapshotArgs.builder()
 *             .creationData(Map.of("sourceId", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}"))
 *             .elasticSanName("elasticsanname")
 *             .resourceGroupName("resourcegroupname")
 *             .snapshotName("snapshotname")
 *             .volumeGroupName("volumegroupname")
 *             .build());
 *     }
 * }
 * ```
 * ### VolumeSnapshots_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeSnapshot = new AzureNative.ElasticSan.VolumeSnapshot("volumeSnapshot", new()
 *     {
 *         CreationData = new AzureNative.ElasticSan.Inputs.SnapshotCreationDataArgs
 *         {
 *             SourceId = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}",
 *         },
 *         ElasticSanName = "elasticsanname",
 *         ResourceGroupName = "resourcegroupname",
 *         SnapshotName = "snapshotname",
 *         VolumeGroupName = "volumegroupname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolumeSnapshot(ctx, "volumeSnapshot", &elasticsan.VolumeSnapshotArgs{
 * 			CreationData: &elasticsan.SnapshotCreationDataArgs{
 * 				SourceId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}"),
 * 			},
 * 			ElasticSanName:    pulumi.String("elasticsanname"),
 * 			ResourceGroupName: pulumi.String("resourcegroupname"),
 * 			SnapshotName:      pulumi.String("snapshotname"),
 * 			VolumeGroupName:   pulumi.String("volumegroupname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.VolumeSnapshot;
 * import com.pulumi.azurenative.elasticsan.VolumeSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeSnapshot = new VolumeSnapshot("volumeSnapshot", VolumeSnapshotArgs.builder()
 *             .creationData(Map.of("sourceId", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}"))
 *             .elasticSanName("elasticsanname")
 *             .resourceGroupName("resourcegroupname")
 *             .snapshotName("snapshotname")
 *             .volumeGroupName("volumegroupname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elasticsan:VolumeSnapshot qukfugetqthsufp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/snapshots/{snapshotName}
 * ```
 */
public class VolumeSnapshot internal constructor(
    override val javaResource: com.pulumi.azurenative.elasticsan.VolumeSnapshot,
) : KotlinCustomResource(javaResource, VolumeSnapshotMapper) {
    /**
     * Data used when creating a volume snapshot.
     */
    public val creationData: Output<SnapshotCreationDataResponse>
        get() = javaResource.creationData().applyValue({ args0 ->
            args0.let({ args0 ->
                snapshotCreationDataResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the operation on the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Size of Source Volume
     */
    public val sourceVolumeSizeGiB: Output<Double>
        get() = javaResource.sourceVolumeSizeGiB().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Source Volume Name of a snapshot
     */
    public val volumeName: Output<String>
        get() = javaResource.volumeName().applyValue({ args0 -> args0 })
}

public object VolumeSnapshotMapper : ResourceMapper<VolumeSnapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.elasticsan.VolumeSnapshot::class == javaResource::class

    override fun map(javaResource: Resource): VolumeSnapshot = VolumeSnapshot(
        javaResource as
            com.pulumi.azurenative.elasticsan.VolumeSnapshot,
    )
}

/**
 * @see [VolumeSnapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VolumeSnapshot].
 */
public suspend fun volumeSnapshot(
    name: String,
    block: suspend VolumeSnapshotResourceBuilder.() -> Unit,
): VolumeSnapshot {
    val builder = VolumeSnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VolumeSnapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun volumeSnapshot(name: String): VolumeSnapshot {
    val builder = VolumeSnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
