@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of encryption
 */
public enum class EncryptionType(
    public val javaValue: com.pulumi.azurenative.elasticsan.enums.EncryptionType,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.enums.EncryptionType> {
    /**
     * Volume is encrypted at rest with Platform managed key. It is the default encryption type.
     */
    EncryptionAtRestWithPlatformKey(com.pulumi.azurenative.elasticsan.enums.EncryptionType.EncryptionAtRestWithPlatformKey),
    ;

    override fun toJava(): com.pulumi.azurenative.elasticsan.enums.EncryptionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elasticsan.enums.EncryptionType):
            EncryptionType = EncryptionType.values().first { it.javaValue == javaType }
    }
}
