@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The sku name.
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.elasticsan.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.enums.SkuName> {
    /**
     * Premium locally redundant storage
     */
    Premium_LRS(com.pulumi.azurenative.elasticsan.enums.SkuName.Premium_LRS),

    /**
     * Premium zone redundant storage
     */
    Premium_ZRS(com.pulumi.azurenative.elasticsan.enums.SkuName.Premium_ZRS),
    ;

    override fun toJava(): com.pulumi.azurenative.elasticsan.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elasticsan.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
