@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.inputs

import com.pulumi.azurenative.elasticsan.inputs.SourceCreationDataArgs.builder
import com.pulumi.azurenative.elasticsan.kotlin.enums.VolumeCreateOption
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data source used when creating the volume.
 * @property createSource This enumerates the possible sources of a volume creation.
 * @property sourceUri If createOption is Copy, this is the ARM id of the source snapshot or disk. If createOption is Restore, this is the ARM-like id of the source disk restore point.
 */
public data class SourceCreationDataArgs(
    public val createSource: Output<VolumeCreateOption>? = null,
    public val sourceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.inputs.SourceCreationDataArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.inputs.SourceCreationDataArgs =
        com.pulumi.azurenative.elasticsan.inputs.SourceCreationDataArgs.builder()
            .createSource(createSource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceUri(sourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SourceCreationDataArgs].
 */
@PulumiTagMarker
public class SourceCreationDataArgsBuilder internal constructor() {
    private var createSource: Output<VolumeCreateOption>? = null

    private var sourceUri: Output<String>? = null

    /**
     * @param value This enumerates the possible sources of a volume creation.
     */
    @JvmName("xwacrrybtrgeksww")
    public suspend fun createSource(`value`: Output<VolumeCreateOption>) {
        this.createSource = value
    }

    /**
     * @param value If createOption is Copy, this is the ARM id of the source snapshot or disk. If createOption is Restore, this is the ARM-like id of the source disk restore point.
     */
    @JvmName("gkxjvexslcbrdkdi")
    public suspend fun sourceUri(`value`: Output<String>) {
        this.sourceUri = value
    }

    /**
     * @param value This enumerates the possible sources of a volume creation.
     */
    @JvmName("yufysgedalwjrftj")
    public suspend fun createSource(`value`: VolumeCreateOption?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createSource = mapped
    }

    /**
     * @param value If createOption is Copy, this is the ARM id of the source snapshot or disk. If createOption is Restore, this is the ARM-like id of the source disk restore point.
     */
    @JvmName("eobjknillhaahibi")
    public suspend fun sourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceUri = mapped
    }

    internal fun build(): SourceCreationDataArgs = SourceCreationDataArgs(
        createSource = createSource,
        sourceUri = sourceUri,
    )
}
