@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Iscsi target information
 * @property provisioningState State of the operation on the resource.
 * @property status Operational status of the iSCSI Target.
 * @property targetIqn iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server".
 * @property targetPortalHostname iSCSI Target Portal Host Name
 * @property targetPortalPort iSCSI Target Portal Port
 */
public data class IscsiTargetInfoResponse(
    public val provisioningState: String,
    public val status: String? = null,
    public val targetIqn: String,
    public val targetPortalHostname: String,
    public val targetPortalPort: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.elasticsan.outputs.IscsiTargetInfoResponse):
            IscsiTargetInfoResponse = IscsiTargetInfoResponse(
            provisioningState = javaType.provisioningState(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            targetIqn = javaType.targetIqn(),
            targetPortalHostname = javaType.targetPortalHostname(),
            targetPortalPort = javaType.targetPortalPort(),
        )
    }
}
