@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin.inputs

import com.pulumi.azurenative.engagementfabric.inputs.GetChannelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Account Name
 * @property channelName Channel Name
 * @property resourceGroupName Resource Group Name
 */
public data class GetChannelPlainArgs(
    public val accountName: String,
    public val channelName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.engagementfabric.inputs.GetChannelPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.engagementfabric.inputs.GetChannelPlainArgs =
        com.pulumi.azurenative.engagementfabric.inputs.GetChannelPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .channelName(channelName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetChannelPlainArgs].
 */
@PulumiTagMarker
public class GetChannelPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var channelName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Account Name
     */
    @JvmName("ifmillhnhgamwrkn")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Channel Name
     */
    @JvmName("nvdblgmfqjwtwrrk")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.channelName = mapped
    }

    /**
     * @param value Resource Group Name
     */
    @JvmName("guihmrikvnhqvgei")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetChannelPlainArgs = GetChannelPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
