@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The description of the EngagementFabric account key
 * @property name The name of the key
 * @property rank The rank of the key
 * @property value The value of the key
 */
public data class KeyDescriptionResponse(
    public val name: String,
    public val rank: String,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.engagementfabric.outputs.KeyDescriptionResponse):
            KeyDescriptionResponse = KeyDescriptionResponse(
            name = javaType.name(),
            rank = javaType.rank(),
            `value` = javaType.`value`(),
        )
    }
}
