@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.enterpriseknowledgegraph.kotlin

import com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseknowledgegraphFunctions.getEnterpriseKnowledgeGraphPlain
import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.inputs.GetEnterpriseKnowledgeGraphPlainArgs
import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.inputs.GetEnterpriseKnowledgeGraphPlainArgsBuilder
import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.outputs.GetEnterpriseKnowledgeGraphResult
import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.outputs.GetEnterpriseKnowledgeGraphResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object EnterpriseknowledgegraphFunctions {
    /**
     * Returns a EnterpriseKnowledgeGraph service specified by the parameters.
     * Azure REST API version: 2018-12-03.
     * @param argument null
     * @return EnterpriseKnowledgeGraph resource definition
     */
    public suspend fun getEnterpriseKnowledgeGraph(argument: GetEnterpriseKnowledgeGraphPlainArgs):
        GetEnterpriseKnowledgeGraphResult =
        toKotlin(getEnterpriseKnowledgeGraphPlain(argument.toJava()).await())

    /**
     * @see [getEnterpriseKnowledgeGraph].
     * @param resourceGroupName The name of the EnterpriseKnowledgeGraph resource group in the user subscription.
     * @param resourceName The name of the EnterpriseKnowledgeGraph resource.
     * @return EnterpriseKnowledgeGraph resource definition
     */
    public suspend fun getEnterpriseKnowledgeGraph(resourceGroupName: String, resourceName: String):
        GetEnterpriseKnowledgeGraphResult {
        val argument = GetEnterpriseKnowledgeGraphPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return toKotlin(getEnterpriseKnowledgeGraphPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnterpriseKnowledgeGraph].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;enterpriseknowledgegraph&#46;kotlin&#46;inputs&#46;GetEnterpriseKnowledgeGraphPlainArgs].
     * @return EnterpriseKnowledgeGraph resource definition
     */
    public suspend
    fun getEnterpriseKnowledgeGraph(argument: suspend GetEnterpriseKnowledgeGraphPlainArgsBuilder.() -> Unit):
        GetEnterpriseKnowledgeGraphResult {
        val builder = GetEnterpriseKnowledgeGraphPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getEnterpriseKnowledgeGraphPlain(builtArgument.toJava()).await())
    }
}
