@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.inputs

import com.pulumi.azurenative.enterpriseknowledgegraph.inputs.EnterpriseKnowledgeGraphPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the EnterpriseKnowledgeGraph.
 * @property description The description of the EnterpriseKnowledgeGraph
 * @property metadata Specifies the metadata  of the resource.
 * @property provisioningState The state of EnterpriseKnowledgeGraph provisioning
 */
public data class EnterpriseKnowledgeGraphPropertiesArgs(
    public val description: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val provisioningState: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.enterpriseknowledgegraph.inputs.EnterpriseKnowledgeGraphPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.enterpriseknowledgegraph.inputs.EnterpriseKnowledgeGraphPropertiesArgs =
        com.pulumi.azurenative.enterpriseknowledgegraph.inputs.EnterpriseKnowledgeGraphPropertiesArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseKnowledgeGraphPropertiesArgs].
 */
@PulumiTagMarker
public class EnterpriseKnowledgeGraphPropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var provisioningState: Output<String>? = null

    /**
     * @param value The description of the EnterpriseKnowledgeGraph
     */
    @JvmName("brmbomqnjlugmiou")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the metadata  of the resource.
     */
    @JvmName("rvbfvyclbiknemjw")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The state of EnterpriseKnowledgeGraph provisioning
     */
    @JvmName("jtdaehvtmuaokpeu")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The description of the EnterpriseKnowledgeGraph
     */
    @JvmName("nuicnvicvsfemwca")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the metadata  of the resource.
     */
    @JvmName("tebsdjdrxugexkbg")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The state of EnterpriseKnowledgeGraph provisioning
     */
    @JvmName("vyjdggpovkvibsyu")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): EnterpriseKnowledgeGraphPropertiesArgs =
        EnterpriseKnowledgeGraphPropertiesArgs(
            description = description,
            metadata = metadata,
            provisioningState = provisioningState,
        )
}
