@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The parameters to provide for the EnterpriseKnowledgeGraph.
 * @property description The description of the EnterpriseKnowledgeGraph
 * @property metadata Specifies the metadata  of the resource.
 * @property provisioningState The state of EnterpriseKnowledgeGraph provisioning
 */
public data class EnterpriseKnowledgeGraphPropertiesResponse(
    public val description: String? = null,
    public val metadata: Any? = null,
    public val provisioningState: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.enterpriseknowledgegraph.outputs.EnterpriseKnowledgeGraphPropertiesResponse):
            EnterpriseKnowledgeGraphPropertiesResponse = EnterpriseKnowledgeGraphPropertiesResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
