@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.DeadLetterWithResourceIdentityResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.DeliveryWithResourceIdentityResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.EventSubscriptionFilterResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.RetryPolicyResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.StorageBlobDeadLetterDestinationResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.eventgrid.kotlin.outputs.DeadLetterWithResourceIdentityResponse.Companion.toKotlin as deadLetterWithResourceIdentityResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.DeliveryWithResourceIdentityResponse.Companion.toKotlin as deliveryWithResourceIdentityResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.EventSubscriptionFilterResponse.Companion.toKotlin as eventSubscriptionFilterResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.RetryPolicyResponse.Companion.toKotlin as retryPolicyResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.StorageBlobDeadLetterDestinationResponse.Companion.toKotlin as storageBlobDeadLetterDestinationResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [EventSubscription].
 */
@PulumiTagMarker
public class EventSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventSubscriptionArgs = EventSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventSubscriptionArgsBuilder.() -> Unit) {
        val builder = EventSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.eventgrid.EventSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EventSubscription(builtJavaResource)
    }
}

/**
 * Event Subscription
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2017-06-15-preview, 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.EventHubEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "EventHub",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * 			Destination: eventgrid.EventHubEventSubscriptionDestination{
 * 				EndpointType: "EventHub",
 * 				ResourceId:   "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1",
 * 			},
 * 			EventSubscriptionName: pulumi.String("examplesubscription1"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 				SubjectBeginsWith:      pulumi.String("ExamplePrefix"),
 * 				SubjectEndsWith:        pulumi.String("ExampleSuffix"),
 * 			},
 * 			Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "EventHub"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_AzureFunctionDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.AzureFunctionEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "AzureFunction",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Web/sites/ContosoSite/funtions/ContosoFunc",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.AzureFunctionEventSubscriptionDestination{
 * EndpointType: "AzureFunction",
 * ResourceId: "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Web/sites/ContosoSite/funtions/ContosoFunc",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "AzureFunction"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Web/sites/ContosoSite/funtions/ContosoFunc")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_EventHubDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.EventHubEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "EventHub",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.EventHubEventSubscriptionDestination{
 * EndpointType: "EventHub",
 * ResourceId: "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "EventHub"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_HybridConnectionDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.HybridConnectionEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "HybridConnection",
 *             ResourceId = "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Relay/namespaces/ContosoNamespace/hybridConnections/HC1",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.HybridConnectionEventSubscriptionDestination{
 * EndpointType: "HybridConnection",
 * ResourceId: "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Relay/namespaces/ContosoNamespace/hybridConnections/HC1",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "HybridConnection"),
 *                 Map.entry("resourceId", "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Relay/namespaces/ContosoNamespace/hybridConnections/HC1")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_ServiceBusQueueDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.ServiceBusQueueEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "ServiceBusQueue",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/queues/SBQ",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.ServiceBusQueueEventSubscriptionDestination{
 * EndpointType: "ServiceBusQueue",
 * ResourceId: "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/queues/SBQ",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "ServiceBusQueue"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/queues/SBQ")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_ServiceBusTopicDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.ServiceBusTopicEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "ServiceBusTopic",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/topics/SBT",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.ServiceBusTopicEventSubscriptionDestination{
 * EndpointType: "ServiceBusTopic",
 * ResourceId: "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/topics/SBT",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "ServiceBusTopic"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/topics/SBT")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_StorageQueueDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.StorageQueueEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "StorageQueue",
 *             QueueName = "queue1",
 *             ResourceId = "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.StorageQueueEventSubscriptionDestination{
 * EndpointType: "StorageQueue",
 * QueueName: "queue1",
 * ResourceId: "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "StorageQueue"),
 *                 Map.entry("queueName", "queue1"),
 *                 Map.entry("resourceId", "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_WebhookDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.WebHookEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "WebHook",
 *             EndpointUrl = "https://azurefunctionexample.azurewebsites.net/runtime/webhooks/EventGrid?functionName=EventGridTrigger1&code=PASSWORDCODE",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * 			Destination: eventgrid.WebHookEventSubscriptionDestination{
 * 				EndpointType: "WebHook",
 * 				EndpointUrl:  "https://azurefunctionexample.azurewebsites.net/runtime/webhooks/EventGrid?functionName=EventGridTrigger1&code=PASSWORDCODE",
 * 			},
 * 			EventSubscriptionName: pulumi.String("examplesubscription1"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 				SubjectBeginsWith:      pulumi.String("ExamplePrefix"),
 * 				SubjectEndsWith:        pulumi.String("ExampleSuffix"),
 * 			},
 * 			Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "WebHook"),
 *                 Map.entry("endpointUrl", "https://azurefunctionexample.azurewebsites.net/runtime/webhooks/EventGrid?functionName=EventGridTrigger1&code=PASSWORDCODE")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.WebHookEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "WebHook",
 *             EndpointUrl = "https://requestb.in/15ksip71",
 *         },
 *         EventSubscriptionName = "examplesubscription10",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventHub/namespaces/examplenamespace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * 			Destination: eventgrid.WebHookEventSubscriptionDestination{
 * 				EndpointType: "WebHook",
 * 				EndpointUrl:  "https://requestb.in/15ksip71",
 * 			},
 * 			EventSubscriptionName: pulumi.String("examplesubscription10"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 				SubjectBeginsWith:      pulumi.String("ExamplePrefix"),
 * 				SubjectEndsWith:        pulumi.String("ExampleSuffix"),
 * 			},
 * 			Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventHub/namespaces/examplenamespace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "WebHook"),
 *                 Map.entry("endpointUrl", "https://requestb.in/15ksip71")
 *             ))
 *             .eventSubscriptionName("examplesubscription10")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventHub/namespaces/examplenamespace1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForResourceGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.WebHookEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "WebHook",
 *             EndpointUrl = "https://requestb.in/15ksip71",
 *         },
 *         EventSubscriptionName = "examplesubscription2",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * 			Destination: eventgrid.WebHookEventSubscriptionDestination{
 * 				EndpointType: "WebHook",
 * 				EndpointUrl:  "https://requestb.in/15ksip71",
 * 			},
 * 			EventSubscriptionName: pulumi.String("examplesubscription2"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 				SubjectBeginsWith:      pulumi.String("ExamplePrefix"),
 * 				SubjectEndsWith:        pulumi.String("ExampleSuffix"),
 * 			},
 * 			Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "WebHook"),
 *                 Map.entry("endpointUrl", "https://requestb.in/15ksip71")
 *             ))
 *             .eventSubscriptionName("examplesubscription2")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForSubscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.WebHookEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "WebHook",
 *             EndpointUrl = "https://requestb.in/15ksip71",
 *         },
 *         EventSubscriptionName = "examplesubscription3",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * 			Destination: eventgrid.WebHookEventSubscriptionDestination{
 * 				EndpointType: "WebHook",
 * 				EndpointUrl:  "https://requestb.in/15ksip71",
 * 			},
 * 			EventSubscriptionName: pulumi.String("examplesubscription3"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 			},
 * 			Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "WebHook"),
 *                 Map.entry("endpointUrl", "https://requestb.in/15ksip71")
 *             ))
 *             .eventSubscriptionName("examplesubscription3")
 *             .filter(Map.of("isSubjectCaseSensitive", false))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:EventSubscription examplesubscription3 /{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}
 * ```
 */
public class EventSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.EventSubscription,
) : KotlinCustomResource(javaResource, EventSubscriptionMapper) {
    /**
     * The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    public val deadLetterDestination: Output<StorageBlobDeadLetterDestinationResponse>?
        get() = javaResource.deadLetterDestination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    storageBlobDeadLetterDestinationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    public val deadLetterWithResourceIdentity: Output<DeadLetterWithResourceIdentityResponse>?
        get() = javaResource.deadLetterWithResourceIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deadLetterWithResourceIdentityResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    public val deliveryWithResourceIdentity: Output<DeliveryWithResourceIdentityResponse>?
        get() = javaResource.deliveryWithResourceIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deliveryWithResourceIdentityResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Information about the destination where events have to be delivered for the event subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    public val destination: Output<Any>?
        get() = javaResource.destination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The event delivery schema for the event subscription.
     */
    public val eventDeliverySchema: Output<String>?
        get() = javaResource.eventDeliverySchema().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Expiration time of the event subscription.
     */
    public val expirationTimeUtc: Output<String>?
        get() = javaResource.expirationTimeUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Information about the filter for the event subscription.
     */
    public val filter: Output<EventSubscriptionFilterResponse>?
        get() = javaResource.filter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventSubscriptionFilterResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of user defined labels.
     */
    public val labels: Output<List<String>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the event subscription.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
     */
    public val retryPolicy: Output<RetryPolicyResponse>?
        get() = javaResource.retryPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    retryPolicyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The system metadata relating to Event Subscription resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Name of the topic of the event subscription.
     */
    public val topic: Output<String>
        get() = javaResource.topic().applyValue({ args0 -> args0 })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EventSubscriptionMapper : ResourceMapper<EventSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.EventSubscription::class == javaResource::class

    override fun map(javaResource: Resource): EventSubscription = EventSubscription(
        javaResource as
            com.pulumi.azurenative.eventgrid.EventSubscription,
    )
}

/**
 * @see [EventSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventSubscription].
 */
public suspend fun eventSubscription(
    name: String,
    block: suspend EventSubscriptionResourceBuilder.() -> Unit,
): EventSubscription {
    val builder = EventSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventSubscription(name: String): EventSubscription {
    val builder = EventSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
