@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.EventgridFunctions.getCaCertificatePlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getChannelFullUrlPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getChannelPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getClientGroupPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getClientPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getDomainEventSubscriptionDeliveryAttributesPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getDomainEventSubscriptionFullUrlPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getDomainEventSubscriptionPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getDomainPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getDomainTopicEventSubscriptionDeliveryAttributesPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getDomainTopicEventSubscriptionFullUrlPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getDomainTopicEventSubscriptionPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getDomainTopicPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getEventSubscriptionDeliveryAttributesPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getEventSubscriptionFullUrlPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getEventSubscriptionPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getNamespacePlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getNamespaceTopicEventSubscriptionDeliveryAttributesPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getNamespaceTopicEventSubscriptionPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getNamespaceTopicPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getPartnerConfigurationPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getPartnerDestinationPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getPartnerNamespacePlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getPartnerRegistrationPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getPartnerTopicEventSubscriptionDeliveryAttributesPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getPartnerTopicEventSubscriptionFullUrlPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getPartnerTopicEventSubscriptionPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getPartnerTopicPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getPermissionBindingPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getSystemTopicEventSubscriptionDeliveryAttributesPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getSystemTopicEventSubscriptionFullUrlPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getSystemTopicEventSubscriptionPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getSystemTopicPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getTopicEventSubscriptionDeliveryAttributesPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getTopicEventSubscriptionFullUrlPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getTopicEventSubscriptionPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getTopicPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.getTopicSpacePlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.listDomainSharedAccessKeysPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.listNamespaceSharedAccessKeysPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.listNamespaceTopicSharedAccessKeysPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.listPartnerNamespaceSharedAccessKeysPlain
import com.pulumi.azurenative.eventgrid.EventgridFunctions.listTopicSharedAccessKeysPlain
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetCaCertificatePlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetCaCertificatePlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetChannelFullUrlPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetChannelFullUrlPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetChannelPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetChannelPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetClientGroupPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetClientGroupPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetClientPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetClientPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainEventSubscriptionDeliveryAttributesPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainEventSubscriptionDeliveryAttributesPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainEventSubscriptionFullUrlPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainEventSubscriptionFullUrlPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainEventSubscriptionPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainEventSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainTopicEventSubscriptionDeliveryAttributesPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainTopicEventSubscriptionFullUrlPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainTopicEventSubscriptionFullUrlPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainTopicEventSubscriptionPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainTopicEventSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainTopicPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetDomainTopicPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetEventSubscriptionDeliveryAttributesPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetEventSubscriptionDeliveryAttributesPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetEventSubscriptionFullUrlPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetEventSubscriptionFullUrlPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetEventSubscriptionPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetEventSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetNamespacePlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetNamespacePlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetNamespaceTopicEventSubscriptionPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetNamespaceTopicEventSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetNamespaceTopicPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetNamespaceTopicPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerConfigurationPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerConfigurationPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerDestinationPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerDestinationPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerNamespacePlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerNamespacePlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerRegistrationPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerRegistrationPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerTopicEventSubscriptionFullUrlPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerTopicEventSubscriptionFullUrlPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerTopicEventSubscriptionPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerTopicEventSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerTopicPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPartnerTopicPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPermissionBindingPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPermissionBindingPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetSystemTopicEventSubscriptionDeliveryAttributesPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetSystemTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetSystemTopicEventSubscriptionFullUrlPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetSystemTopicEventSubscriptionFullUrlPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetSystemTopicEventSubscriptionPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetSystemTopicEventSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetSystemTopicPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetSystemTopicPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetTopicEventSubscriptionDeliveryAttributesPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetTopicEventSubscriptionFullUrlPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetTopicEventSubscriptionFullUrlPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetTopicEventSubscriptionPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetTopicEventSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetTopicPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetTopicPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetTopicSpacePlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.GetTopicSpacePlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ListDomainSharedAccessKeysPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ListDomainSharedAccessKeysPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ListNamespaceSharedAccessKeysPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ListNamespaceSharedAccessKeysPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ListNamespaceTopicSharedAccessKeysPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ListNamespaceTopicSharedAccessKeysPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ListPartnerNamespaceSharedAccessKeysPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ListPartnerNamespaceSharedAccessKeysPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ListTopicSharedAccessKeysPlainArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ListTopicSharedAccessKeysPlainArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetCaCertificateResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetChannelFullUrlResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetChannelResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetClientGroupResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetClientResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainEventSubscriptionDeliveryAttributesResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainEventSubscriptionFullUrlResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainEventSubscriptionResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainTopicEventSubscriptionDeliveryAttributesResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainTopicEventSubscriptionFullUrlResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainTopicEventSubscriptionResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainTopicResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetEventSubscriptionDeliveryAttributesResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetEventSubscriptionFullUrlResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetEventSubscriptionResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetNamespaceResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetNamespaceTopicEventSubscriptionDeliveryAttributesResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetNamespaceTopicEventSubscriptionResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetNamespaceTopicResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerConfigurationResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerDestinationResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerNamespaceResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerRegistrationResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerTopicEventSubscriptionDeliveryAttributesResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerTopicEventSubscriptionFullUrlResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerTopicEventSubscriptionResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerTopicResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPermissionBindingResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetSystemTopicEventSubscriptionDeliveryAttributesResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetSystemTopicEventSubscriptionFullUrlResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetSystemTopicEventSubscriptionResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetSystemTopicResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetTopicEventSubscriptionDeliveryAttributesResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetTopicEventSubscriptionFullUrlResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetTopicEventSubscriptionResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetTopicResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetTopicSpaceResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ListDomainSharedAccessKeysResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ListNamespaceSharedAccessKeysResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ListNamespaceTopicSharedAccessKeysResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ListPartnerNamespaceSharedAccessKeysResult
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ListTopicSharedAccessKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetCaCertificateResult.Companion.toKotlin as getCaCertificateResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetChannelFullUrlResult.Companion.toKotlin as getChannelFullUrlResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetChannelResult.Companion.toKotlin as getChannelResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetClientGroupResult.Companion.toKotlin as getClientGroupResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetClientResult.Companion.toKotlin as getClientResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainEventSubscriptionDeliveryAttributesResult.Companion.toKotlin as getDomainEventSubscriptionDeliveryAttributesResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainEventSubscriptionFullUrlResult.Companion.toKotlin as getDomainEventSubscriptionFullUrlResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainEventSubscriptionResult.Companion.toKotlin as getDomainEventSubscriptionResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainResult.Companion.toKotlin as getDomainResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainTopicEventSubscriptionDeliveryAttributesResult.Companion.toKotlin as getDomainTopicEventSubscriptionDeliveryAttributesResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainTopicEventSubscriptionFullUrlResult.Companion.toKotlin as getDomainTopicEventSubscriptionFullUrlResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainTopicEventSubscriptionResult.Companion.toKotlin as getDomainTopicEventSubscriptionResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetDomainTopicResult.Companion.toKotlin as getDomainTopicResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetEventSubscriptionDeliveryAttributesResult.Companion.toKotlin as getEventSubscriptionDeliveryAttributesResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetEventSubscriptionFullUrlResult.Companion.toKotlin as getEventSubscriptionFullUrlResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetEventSubscriptionResult.Companion.toKotlin as getEventSubscriptionResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetNamespaceResult.Companion.toKotlin as getNamespaceResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetNamespaceTopicEventSubscriptionDeliveryAttributesResult.Companion.toKotlin as getNamespaceTopicEventSubscriptionDeliveryAttributesResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetNamespaceTopicEventSubscriptionResult.Companion.toKotlin as getNamespaceTopicEventSubscriptionResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetNamespaceTopicResult.Companion.toKotlin as getNamespaceTopicResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerConfigurationResult.Companion.toKotlin as getPartnerConfigurationResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerDestinationResult.Companion.toKotlin as getPartnerDestinationResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerNamespaceResult.Companion.toKotlin as getPartnerNamespaceResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerRegistrationResult.Companion.toKotlin as getPartnerRegistrationResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerTopicEventSubscriptionDeliveryAttributesResult.Companion.toKotlin as getPartnerTopicEventSubscriptionDeliveryAttributesResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerTopicEventSubscriptionFullUrlResult.Companion.toKotlin as getPartnerTopicEventSubscriptionFullUrlResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerTopicEventSubscriptionResult.Companion.toKotlin as getPartnerTopicEventSubscriptionResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPartnerTopicResult.Companion.toKotlin as getPartnerTopicResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPermissionBindingResult.Companion.toKotlin as getPermissionBindingResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetSystemTopicEventSubscriptionDeliveryAttributesResult.Companion.toKotlin as getSystemTopicEventSubscriptionDeliveryAttributesResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetSystemTopicEventSubscriptionFullUrlResult.Companion.toKotlin as getSystemTopicEventSubscriptionFullUrlResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetSystemTopicEventSubscriptionResult.Companion.toKotlin as getSystemTopicEventSubscriptionResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetSystemTopicResult.Companion.toKotlin as getSystemTopicResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetTopicEventSubscriptionDeliveryAttributesResult.Companion.toKotlin as getTopicEventSubscriptionDeliveryAttributesResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetTopicEventSubscriptionFullUrlResult.Companion.toKotlin as getTopicEventSubscriptionFullUrlResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetTopicEventSubscriptionResult.Companion.toKotlin as getTopicEventSubscriptionResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetTopicResult.Companion.toKotlin as getTopicResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.GetTopicSpaceResult.Companion.toKotlin as getTopicSpaceResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ListDomainSharedAccessKeysResult.Companion.toKotlin as listDomainSharedAccessKeysResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ListNamespaceSharedAccessKeysResult.Companion.toKotlin as listNamespaceSharedAccessKeysResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ListNamespaceTopicSharedAccessKeysResult.Companion.toKotlin as listNamespaceTopicSharedAccessKeysResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ListPartnerNamespaceSharedAccessKeysResult.Companion.toKotlin as listPartnerNamespaceSharedAccessKeysResultToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.ListTopicSharedAccessKeysResult.Companion.toKotlin as listTopicSharedAccessKeysResultToKotlin

public object EventgridFunctions {
    /**
     * Get properties of a CA certificate.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-12-15-preview.
     * @param argument null
     * @return The CA Certificate resource.
     */
    public suspend fun getCaCertificate(argument: GetCaCertificatePlainArgs): GetCaCertificateResult =
        getCaCertificateResultToKotlin(getCaCertificatePlain(argument.toJava()).await())

    /**
     * @see [getCaCertificate].
     * @param caCertificateName Name of the CA certificate.
     * @param namespaceName Name of the namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return The CA Certificate resource.
     */
    public suspend fun getCaCertificate(
        caCertificateName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetCaCertificateResult {
        val argument = GetCaCertificatePlainArgs(
            caCertificateName = caCertificateName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getCaCertificateResultToKotlin(getCaCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getCaCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetCaCertificatePlainArgs].
     * @return The CA Certificate resource.
     */
    public suspend
    fun getCaCertificate(argument: suspend GetCaCertificatePlainArgsBuilder.() -> Unit):
        GetCaCertificateResult {
        val builder = GetCaCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCaCertificateResultToKotlin(getCaCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a channel.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Channel info.
     */
    public suspend fun getChannel(argument: GetChannelPlainArgs): GetChannelResult =
        getChannelResultToKotlin(getChannelPlain(argument.toJava()).await())

    /**
     * @see [getChannel].
     * @param channelName Name of the channel.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @return Channel info.
     */
    public suspend fun getChannel(
        channelName: String,
        partnerNamespaceName: String,
        resourceGroupName: String,
    ): GetChannelResult {
        val argument = GetChannelPlainArgs(
            channelName = channelName,
            partnerNamespaceName = partnerNamespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getChannelResultToKotlin(getChannelPlain(argument.toJava()).await())
    }

    /**
     * @see [getChannel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetChannelPlainArgs].
     * @return Channel info.
     */
    public suspend fun getChannel(argument: suspend GetChannelPlainArgsBuilder.() -> Unit):
        GetChannelResult {
        val builder = GetChannelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getChannelResultToKotlin(getChannelPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the full endpoint URL of a partner destination channel.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Full endpoint url of an event subscription
     */
    public suspend fun getChannelFullUrl(argument: GetChannelFullUrlPlainArgs):
        GetChannelFullUrlResult =
        getChannelFullUrlResultToKotlin(getChannelFullUrlPlain(argument.toJava()).await())

    /**
     * @see [getChannelFullUrl].
     * @param channelName Name of the Channel.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @return Full endpoint url of an event subscription
     */
    public suspend fun getChannelFullUrl(
        channelName: String,
        partnerNamespaceName: String,
        resourceGroupName: String,
    ): GetChannelFullUrlResult {
        val argument = GetChannelFullUrlPlainArgs(
            channelName = channelName,
            partnerNamespaceName = partnerNamespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getChannelFullUrlResultToKotlin(getChannelFullUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getChannelFullUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetChannelFullUrlPlainArgs].
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getChannelFullUrl(argument: suspend GetChannelFullUrlPlainArgsBuilder.() -> Unit):
        GetChannelFullUrlResult {
        val builder = GetChannelFullUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getChannelFullUrlResultToKotlin(getChannelFullUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a client.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-12-15-preview.
     * @param argument null
     * @return The Client resource.
     */
    public suspend fun getClient(argument: GetClientPlainArgs): GetClientResult =
        getClientResultToKotlin(getClientPlain(argument.toJava()).await())

    /**
     * @see [getClient].
     * @param clientName Name of the client.
     * @param namespaceName Name of the namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return The Client resource.
     */
    public suspend fun getClient(
        clientName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetClientResult {
        val argument = GetClientPlainArgs(
            clientName = clientName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getClientResultToKotlin(getClientPlain(argument.toJava()).await())
    }

    /**
     * @see [getClient].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetClientPlainArgs].
     * @return The Client resource.
     */
    public suspend fun getClient(argument: suspend GetClientPlainArgsBuilder.() -> Unit):
        GetClientResult {
        val builder = GetClientPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClientResultToKotlin(getClientPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a client group.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-12-15-preview.
     * @param argument null
     * @return The Client group resource.
     */
    public suspend fun getClientGroup(argument: GetClientGroupPlainArgs): GetClientGroupResult =
        getClientGroupResultToKotlin(getClientGroupPlain(argument.toJava()).await())

    /**
     * @see [getClientGroup].
     * @param clientGroupName Name of the client group.
     * @param namespaceName Name of the namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return The Client group resource.
     */
    public suspend fun getClientGroup(
        clientGroupName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetClientGroupResult {
        val argument = GetClientGroupPlainArgs(
            clientGroupName = clientGroupName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getClientGroupResultToKotlin(getClientGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getClientGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetClientGroupPlainArgs].
     * @return The Client group resource.
     */
    public suspend fun getClientGroup(argument: suspend GetClientGroupPlainArgsBuilder.() -> Unit):
        GetClientGroupResult {
        val builder = GetClientGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClientGroupResultToKotlin(getClientGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a domain.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2020-04-01-preview, 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return EventGrid Domain.
     */
    public suspend fun getDomain(argument: GetDomainPlainArgs): GetDomainResult =
        getDomainResultToKotlin(getDomainPlain(argument.toJava()).await())

    /**
     * @see [getDomain].
     * @param domainName Name of the domain.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return EventGrid Domain.
     */
    public suspend fun getDomain(domainName: String, resourceGroupName: String): GetDomainResult {
        val argument = GetDomainPlainArgs(
            domainName = domainName,
            resourceGroupName = resourceGroupName,
        )
        return getDomainResultToKotlin(getDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomain].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetDomainPlainArgs].
     * @return EventGrid Domain.
     */
    public suspend fun getDomain(argument: suspend GetDomainPlainArgsBuilder.() -> Unit):
        GetDomainResult {
        val builder = GetDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainResultToKotlin(getDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of an event subscription of a domain.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Event Subscription
     */
    public suspend fun getDomainEventSubscription(argument: GetDomainEventSubscriptionPlainArgs):
        GetDomainEventSubscriptionResult =
        getDomainEventSubscriptionResultToKotlin(getDomainEventSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getDomainEventSubscription].
     * @param domainName Name of the partner topic.
     * @param eventSubscriptionName Name of the event subscription to be found. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Event Subscription
     */
    public suspend fun getDomainEventSubscription(
        domainName: String,
        eventSubscriptionName: String,
        resourceGroupName: String,
    ): GetDomainEventSubscriptionResult {
        val argument = GetDomainEventSubscriptionPlainArgs(
            domainName = domainName,
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
        )
        return getDomainEventSubscriptionResultToKotlin(getDomainEventSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainEventSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetDomainEventSubscriptionPlainArgs].
     * @return Event Subscription
     */
    public suspend
    fun getDomainEventSubscription(argument: suspend GetDomainEventSubscriptionPlainArgsBuilder.() -> Unit):
        GetDomainEventSubscriptionResult {
        val builder = GetDomainEventSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainEventSubscriptionResultToKotlin(getDomainEventSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get all delivery attributes for an event subscription for domain.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getDomainEventSubscriptionDeliveryAttributes(argument: GetDomainEventSubscriptionDeliveryAttributesPlainArgs):
        GetDomainEventSubscriptionDeliveryAttributesResult =
        getDomainEventSubscriptionDeliveryAttributesResultToKotlin(getDomainEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())

    /**
     * @see [getDomainEventSubscriptionDeliveryAttributes].
     * @param domainName Name of the domain topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Result of the Get delivery attributes operation.
     */
    public suspend fun getDomainEventSubscriptionDeliveryAttributes(
        domainName: String,
        eventSubscriptionName: String,
        resourceGroupName: String,
    ): GetDomainEventSubscriptionDeliveryAttributesResult {
        val argument = GetDomainEventSubscriptionDeliveryAttributesPlainArgs(
            domainName = domainName,
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
        )
        return getDomainEventSubscriptionDeliveryAttributesResultToKotlin(getDomainEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainEventSubscriptionDeliveryAttributes].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetDomainEventSubscriptionDeliveryAttributesPlainArgs].
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getDomainEventSubscriptionDeliveryAttributes(argument: suspend GetDomainEventSubscriptionDeliveryAttributesPlainArgsBuilder.() -> Unit):
        GetDomainEventSubscriptionDeliveryAttributesResult {
        val builder = GetDomainEventSubscriptionDeliveryAttributesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainEventSubscriptionDeliveryAttributesResultToKotlin(getDomainEventSubscriptionDeliveryAttributesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the full endpoint URL for an event subscription for domain.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getDomainEventSubscriptionFullUrl(argument: GetDomainEventSubscriptionFullUrlPlainArgs):
        GetDomainEventSubscriptionFullUrlResult =
        getDomainEventSubscriptionFullUrlResultToKotlin(getDomainEventSubscriptionFullUrlPlain(argument.toJava()).await())

    /**
     * @see [getDomainEventSubscriptionFullUrl].
     * @param domainName Name of the domain topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Full endpoint url of an event subscription
     */
    public suspend fun getDomainEventSubscriptionFullUrl(
        domainName: String,
        eventSubscriptionName: String,
        resourceGroupName: String,
    ): GetDomainEventSubscriptionFullUrlResult {
        val argument = GetDomainEventSubscriptionFullUrlPlainArgs(
            domainName = domainName,
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
        )
        return getDomainEventSubscriptionFullUrlResultToKotlin(getDomainEventSubscriptionFullUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainEventSubscriptionFullUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetDomainEventSubscriptionFullUrlPlainArgs].
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getDomainEventSubscriptionFullUrl(argument: suspend GetDomainEventSubscriptionFullUrlPlainArgsBuilder.() -> Unit):
        GetDomainEventSubscriptionFullUrlResult {
        val builder = GetDomainEventSubscriptionFullUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainEventSubscriptionFullUrlResultToKotlin(getDomainEventSubscriptionFullUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a domain topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Domain Topic.
     */
    public suspend fun getDomainTopic(argument: GetDomainTopicPlainArgs): GetDomainTopicResult =
        getDomainTopicResultToKotlin(getDomainTopicPlain(argument.toJava()).await())

    /**
     * @see [getDomainTopic].
     * @param domainName Name of the domain.
     * @param domainTopicName Name of the topic.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Domain Topic.
     */
    public suspend fun getDomainTopic(
        domainName: String,
        domainTopicName: String,
        resourceGroupName: String,
    ): GetDomainTopicResult {
        val argument = GetDomainTopicPlainArgs(
            domainName = domainName,
            domainTopicName = domainTopicName,
            resourceGroupName = resourceGroupName,
        )
        return getDomainTopicResultToKotlin(getDomainTopicPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainTopic].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetDomainTopicPlainArgs].
     * @return Domain Topic.
     */
    public suspend fun getDomainTopic(argument: suspend GetDomainTopicPlainArgsBuilder.() -> Unit):
        GetDomainTopicResult {
        val builder = GetDomainTopicPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainTopicResultToKotlin(getDomainTopicPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a nested event subscription for a domain topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Event Subscription
     */
    public suspend
    fun getDomainTopicEventSubscription(argument: GetDomainTopicEventSubscriptionPlainArgs):
        GetDomainTopicEventSubscriptionResult =
        getDomainTopicEventSubscriptionResultToKotlin(getDomainTopicEventSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getDomainTopicEventSubscription].
     * @param domainName Name of the top level domain.
     * @param eventSubscriptionName Name of the event subscription.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the domain topic.
     * @return Event Subscription
     */
    public suspend fun getDomainTopicEventSubscription(
        domainName: String,
        eventSubscriptionName: String,
        resourceGroupName: String,
        topicName: String,
    ): GetDomainTopicEventSubscriptionResult {
        val argument = GetDomainTopicEventSubscriptionPlainArgs(
            domainName = domainName,
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getDomainTopicEventSubscriptionResultToKotlin(getDomainTopicEventSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainTopicEventSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetDomainTopicEventSubscriptionPlainArgs].
     * @return Event Subscription
     */
    public suspend
    fun getDomainTopicEventSubscription(argument: suspend GetDomainTopicEventSubscriptionPlainArgsBuilder.() -> Unit):
        GetDomainTopicEventSubscriptionResult {
        val builder = GetDomainTopicEventSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainTopicEventSubscriptionResultToKotlin(getDomainTopicEventSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get all delivery attributes for an event subscription for domain topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getDomainTopicEventSubscriptionDeliveryAttributes(argument: GetDomainTopicEventSubscriptionDeliveryAttributesPlainArgs):
        GetDomainTopicEventSubscriptionDeliveryAttributesResult =
        getDomainTopicEventSubscriptionDeliveryAttributesResultToKotlin(getDomainTopicEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())

    /**
     * @see [getDomainTopicEventSubscriptionDeliveryAttributes].
     * @param domainName Name of the top level domain.
     * @param eventSubscriptionName Name of the event subscription.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the domain topic.
     * @return Result of the Get delivery attributes operation.
     */
    public suspend fun getDomainTopicEventSubscriptionDeliveryAttributes(
        domainName: String,
        eventSubscriptionName: String,
        resourceGroupName: String,
        topicName: String,
    ): GetDomainTopicEventSubscriptionDeliveryAttributesResult {
        val argument = GetDomainTopicEventSubscriptionDeliveryAttributesPlainArgs(
            domainName = domainName,
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getDomainTopicEventSubscriptionDeliveryAttributesResultToKotlin(getDomainTopicEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainTopicEventSubscriptionDeliveryAttributes].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetDomainTopicEventSubscriptionDeliveryAttributesPlainArgs].
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getDomainTopicEventSubscriptionDeliveryAttributes(argument: suspend GetDomainTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder.() -> Unit):
        GetDomainTopicEventSubscriptionDeliveryAttributesResult {
        val builder = GetDomainTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainTopicEventSubscriptionDeliveryAttributesResultToKotlin(getDomainTopicEventSubscriptionDeliveryAttributesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the full endpoint URL for a nested event subscription for domain topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getDomainTopicEventSubscriptionFullUrl(argument: GetDomainTopicEventSubscriptionFullUrlPlainArgs):
        GetDomainTopicEventSubscriptionFullUrlResult =
        getDomainTopicEventSubscriptionFullUrlResultToKotlin(getDomainTopicEventSubscriptionFullUrlPlain(argument.toJava()).await())

    /**
     * @see [getDomainTopicEventSubscriptionFullUrl].
     * @param domainName Name of the top level domain.
     * @param eventSubscriptionName Name of the event subscription.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the domain topic.
     * @return Full endpoint url of an event subscription
     */
    public suspend fun getDomainTopicEventSubscriptionFullUrl(
        domainName: String,
        eventSubscriptionName: String,
        resourceGroupName: String,
        topicName: String,
    ): GetDomainTopicEventSubscriptionFullUrlResult {
        val argument = GetDomainTopicEventSubscriptionFullUrlPlainArgs(
            domainName = domainName,
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getDomainTopicEventSubscriptionFullUrlResultToKotlin(getDomainTopicEventSubscriptionFullUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainTopicEventSubscriptionFullUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetDomainTopicEventSubscriptionFullUrlPlainArgs].
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getDomainTopicEventSubscriptionFullUrl(argument: suspend GetDomainTopicEventSubscriptionFullUrlPlainArgsBuilder.() -> Unit):
        GetDomainTopicEventSubscriptionFullUrlResult {
        val builder = GetDomainTopicEventSubscriptionFullUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainTopicEventSubscriptionFullUrlResultToKotlin(getDomainTopicEventSubscriptionFullUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of an event subscription.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2017-06-15-preview, 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Event Subscription
     */
    public suspend fun getEventSubscription(argument: GetEventSubscriptionPlainArgs):
        GetEventSubscriptionResult =
        getEventSubscriptionResultToKotlin(getEventSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getEventSubscription].
     * @param eventSubscriptionName Name of the event subscription.
     * @param scope The scope of the event subscription. The scope can be a subscription, or a resource group, or a top level resource belonging to a resource provider namespace, or an EventGrid topic. For example, use '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}' for a resource, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for an EventGrid topic.
     * @return Event Subscription
     */
    public suspend fun getEventSubscription(eventSubscriptionName: String, scope: String):
        GetEventSubscriptionResult {
        val argument = GetEventSubscriptionPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            scope = scope,
        )
        return getEventSubscriptionResultToKotlin(getEventSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetEventSubscriptionPlainArgs].
     * @return Event Subscription
     */
    public suspend
    fun getEventSubscription(argument: suspend GetEventSubscriptionPlainArgsBuilder.() -> Unit):
        GetEventSubscriptionResult {
        val builder = GetEventSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventSubscriptionResultToKotlin(getEventSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get all delivery attributes for an event subscription.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getEventSubscriptionDeliveryAttributes(argument: GetEventSubscriptionDeliveryAttributesPlainArgs):
        GetEventSubscriptionDeliveryAttributesResult =
        getEventSubscriptionDeliveryAttributesResultToKotlin(getEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())

    /**
     * @see [getEventSubscriptionDeliveryAttributes].
     * @param eventSubscriptionName Name of the event subscription.
     * @param scope The scope of the event subscription. The scope can be a subscription, or a resource group, or a top level resource belonging to a resource provider namespace, or an EventGrid topic. For example, use '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}' for a resource, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for an EventGrid topic.
     * @return Result of the Get delivery attributes operation.
     */
    public suspend fun getEventSubscriptionDeliveryAttributes(
        eventSubscriptionName: String,
        scope: String,
    ): GetEventSubscriptionDeliveryAttributesResult {
        val argument = GetEventSubscriptionDeliveryAttributesPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            scope = scope,
        )
        return getEventSubscriptionDeliveryAttributesResultToKotlin(getEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventSubscriptionDeliveryAttributes].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetEventSubscriptionDeliveryAttributesPlainArgs].
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getEventSubscriptionDeliveryAttributes(argument: suspend GetEventSubscriptionDeliveryAttributesPlainArgsBuilder.() -> Unit):
        GetEventSubscriptionDeliveryAttributesResult {
        val builder = GetEventSubscriptionDeliveryAttributesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventSubscriptionDeliveryAttributesResultToKotlin(getEventSubscriptionDeliveryAttributesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the full endpoint URL for an event subscription.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2017-06-15-preview, 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Full endpoint url of an event subscription
     */
    public suspend fun getEventSubscriptionFullUrl(argument: GetEventSubscriptionFullUrlPlainArgs):
        GetEventSubscriptionFullUrlResult =
        getEventSubscriptionFullUrlResultToKotlin(getEventSubscriptionFullUrlPlain(argument.toJava()).await())

    /**
     * @see [getEventSubscriptionFullUrl].
     * @param eventSubscriptionName Name of the event subscription.
     * @param scope The scope of the event subscription. The scope can be a subscription, or a resource group, or a top level resource belonging to a resource provider namespace, or an EventGrid topic. For example, use '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}' for a resource, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for an EventGrid topic.
     * @return Full endpoint url of an event subscription
     */
    public suspend fun getEventSubscriptionFullUrl(eventSubscriptionName: String, scope: String):
        GetEventSubscriptionFullUrlResult {
        val argument = GetEventSubscriptionFullUrlPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            scope = scope,
        )
        return getEventSubscriptionFullUrlResultToKotlin(getEventSubscriptionFullUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventSubscriptionFullUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetEventSubscriptionFullUrlPlainArgs].
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getEventSubscriptionFullUrl(argument: suspend GetEventSubscriptionFullUrlPlainArgsBuilder.() -> Unit):
        GetEventSubscriptionFullUrlResult {
        val builder = GetEventSubscriptionFullUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventSubscriptionFullUrlResultToKotlin(getEventSubscriptionFullUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a namespace.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-12-15-preview.
     * @param argument null
     * @return Namespace resource.
     */
    public suspend fun getNamespace(argument: GetNamespacePlainArgs): GetNamespaceResult =
        getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())

    /**
     * @see [getNamespace].
     * @param namespaceName Name of the namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Namespace resource.
     */
    public suspend fun getNamespace(namespaceName: String, resourceGroupName: String):
        GetNamespaceResult {
        val argument = GetNamespacePlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetNamespacePlainArgs].
     * @return Namespace resource.
     */
    public suspend fun getNamespace(argument: suspend GetNamespacePlainArgsBuilder.() -> Unit):
        GetNamespaceResult {
        val builder = GetNamespacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceResultToKotlin(getNamespacePlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a namespace topic.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-12-15-preview.
     * @param argument null
     * @return Namespace topic details.
     */
    public suspend fun getNamespaceTopic(argument: GetNamespaceTopicPlainArgs):
        GetNamespaceTopicResult =
        getNamespaceTopicResultToKotlin(getNamespaceTopicPlain(argument.toJava()).await())

    /**
     * @see [getNamespaceTopic].
     * @param namespaceName Name of the namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the namespace topic.
     * @return Namespace topic details.
     */
    public suspend fun getNamespaceTopic(
        namespaceName: String,
        resourceGroupName: String,
        topicName: String,
    ): GetNamespaceTopicResult {
        val argument = GetNamespaceTopicPlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getNamespaceTopicResultToKotlin(getNamespaceTopicPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceTopic].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetNamespaceTopicPlainArgs].
     * @return Namespace topic details.
     */
    public suspend
    fun getNamespaceTopic(argument: suspend GetNamespaceTopicPlainArgsBuilder.() -> Unit):
        GetNamespaceTopicResult {
        val builder = GetNamespaceTopicPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceTopicResultToKotlin(getNamespaceTopicPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of an event subscription of a namespace topic.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-12-15-preview.
     * @param argument null
     * @return Event Subscription.
     */
    public suspend
    fun getNamespaceTopicEventSubscription(argument: GetNamespaceTopicEventSubscriptionPlainArgs):
        GetNamespaceTopicEventSubscriptionResult =
        getNamespaceTopicEventSubscriptionResultToKotlin(getNamespaceTopicEventSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getNamespaceTopicEventSubscription].
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     * @param namespaceName Name of the namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the namespace topic.
     * @return Event Subscription.
     */
    public suspend fun getNamespaceTopicEventSubscription(
        eventSubscriptionName: String,
        namespaceName: String,
        resourceGroupName: String,
        topicName: String,
    ): GetNamespaceTopicEventSubscriptionResult {
        val argument = GetNamespaceTopicEventSubscriptionPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getNamespaceTopicEventSubscriptionResultToKotlin(getNamespaceTopicEventSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceTopicEventSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetNamespaceTopicEventSubscriptionPlainArgs].
     * @return Event Subscription.
     */
    public suspend
    fun getNamespaceTopicEventSubscription(argument: suspend GetNamespaceTopicEventSubscriptionPlainArgsBuilder.() -> Unit):
        GetNamespaceTopicEventSubscriptionResult {
        val builder = GetNamespaceTopicEventSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceTopicEventSubscriptionResultToKotlin(getNamespaceTopicEventSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get all delivery attributes for an event subscription of a namespace topic.
     * Azure REST API version: 2023-12-15-preview.
     * @param argument null
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getNamespaceTopicEventSubscriptionDeliveryAttributes(argument: GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs):
        GetNamespaceTopicEventSubscriptionDeliveryAttributesResult =
        getNamespaceTopicEventSubscriptionDeliveryAttributesResultToKotlin(getNamespaceTopicEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())

    /**
     * @see [getNamespaceTopicEventSubscriptionDeliveryAttributes].
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     * @param namespaceName Name of the namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the namespace topic.
     * @return Result of the Get delivery attributes operation.
     */
    public suspend fun getNamespaceTopicEventSubscriptionDeliveryAttributes(
        eventSubscriptionName: String,
        namespaceName: String,
        resourceGroupName: String,
        topicName: String,
    ): GetNamespaceTopicEventSubscriptionDeliveryAttributesResult {
        val argument = GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getNamespaceTopicEventSubscriptionDeliveryAttributesResultToKotlin(getNamespaceTopicEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceTopicEventSubscriptionDeliveryAttributes].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs].
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getNamespaceTopicEventSubscriptionDeliveryAttributes(argument: suspend GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder.() -> Unit):
        GetNamespaceTopicEventSubscriptionDeliveryAttributesResult {
        val builder = GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceTopicEventSubscriptionDeliveryAttributesResultToKotlin(getNamespaceTopicEventSubscriptionDeliveryAttributesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a partner configuration.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Partner configuration information
     */
    public suspend fun getPartnerConfiguration(argument: GetPartnerConfigurationPlainArgs):
        GetPartnerConfigurationResult =
        getPartnerConfigurationResultToKotlin(getPartnerConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getPartnerConfiguration].
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Partner configuration information
     */
    public suspend fun getPartnerConfiguration(resourceGroupName: String):
        GetPartnerConfigurationResult {
        val argument = GetPartnerConfigurationPlainArgs(
            resourceGroupName = resourceGroupName,
        )
        return getPartnerConfigurationResultToKotlin(getPartnerConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getPartnerConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetPartnerConfigurationPlainArgs].
     * @return Partner configuration information
     */
    public suspend
    fun getPartnerConfiguration(argument: suspend GetPartnerConfigurationPlainArgsBuilder.() -> Unit):
        GetPartnerConfigurationResult {
        val builder = GetPartnerConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPartnerConfigurationResultToKotlin(getPartnerConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a partner destination.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2021-10-15-preview, 2023-12-15-preview.
     * @param argument null
     * @return Event Grid Partner Destination.
     */
    public suspend fun getPartnerDestination(argument: GetPartnerDestinationPlainArgs):
        GetPartnerDestinationResult =
        getPartnerDestinationResultToKotlin(getPartnerDestinationPlain(argument.toJava()).await())

    /**
     * @see [getPartnerDestination].
     * @param partnerDestinationName Name of the partner destination.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Event Grid Partner Destination.
     */
    public suspend fun getPartnerDestination(
        partnerDestinationName: String,
        resourceGroupName: String,
    ): GetPartnerDestinationResult {
        val argument = GetPartnerDestinationPlainArgs(
            partnerDestinationName = partnerDestinationName,
            resourceGroupName = resourceGroupName,
        )
        return getPartnerDestinationResultToKotlin(getPartnerDestinationPlain(argument.toJava()).await())
    }

    /**
     * @see [getPartnerDestination].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetPartnerDestinationPlainArgs].
     * @return Event Grid Partner Destination.
     */
    public suspend
    fun getPartnerDestination(argument: suspend GetPartnerDestinationPlainArgsBuilder.() -> Unit):
        GetPartnerDestinationResult {
        val builder = GetPartnerDestinationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPartnerDestinationResultToKotlin(getPartnerDestinationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a partner namespace.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return EventGrid Partner Namespace.
     */
    public suspend fun getPartnerNamespace(argument: GetPartnerNamespacePlainArgs):
        GetPartnerNamespaceResult =
        getPartnerNamespaceResultToKotlin(getPartnerNamespacePlain(argument.toJava()).await())

    /**
     * @see [getPartnerNamespace].
     * @param partnerNamespaceName Name of the partner namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return EventGrid Partner Namespace.
     */
    public suspend fun getPartnerNamespace(partnerNamespaceName: String, resourceGroupName: String):
        GetPartnerNamespaceResult {
        val argument = GetPartnerNamespacePlainArgs(
            partnerNamespaceName = partnerNamespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getPartnerNamespaceResultToKotlin(getPartnerNamespacePlain(argument.toJava()).await())
    }

    /**
     * @see [getPartnerNamespace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetPartnerNamespacePlainArgs].
     * @return EventGrid Partner Namespace.
     */
    public suspend
    fun getPartnerNamespace(argument: suspend GetPartnerNamespacePlainArgsBuilder.() -> Unit):
        GetPartnerNamespaceResult {
        val builder = GetPartnerNamespacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPartnerNamespaceResultToKotlin(getPartnerNamespacePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a partner registration with the specified parameters.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2021-10-15-preview, 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Information about a partner registration.
     */
    public suspend fun getPartnerRegistration(argument: GetPartnerRegistrationPlainArgs):
        GetPartnerRegistrationResult =
        getPartnerRegistrationResultToKotlin(getPartnerRegistrationPlain(argument.toJava()).await())

    /**
     * @see [getPartnerRegistration].
     * @param partnerRegistrationName Name of the partner registration.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Information about a partner registration.
     */
    public suspend fun getPartnerRegistration(
        partnerRegistrationName: String,
        resourceGroupName: String,
    ): GetPartnerRegistrationResult {
        val argument = GetPartnerRegistrationPlainArgs(
            partnerRegistrationName = partnerRegistrationName,
            resourceGroupName = resourceGroupName,
        )
        return getPartnerRegistrationResultToKotlin(getPartnerRegistrationPlain(argument.toJava()).await())
    }

    /**
     * @see [getPartnerRegistration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetPartnerRegistrationPlainArgs].
     * @return Information about a partner registration.
     */
    public suspend
    fun getPartnerRegistration(argument: suspend GetPartnerRegistrationPlainArgsBuilder.() -> Unit):
        GetPartnerRegistrationResult {
        val builder = GetPartnerRegistrationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPartnerRegistrationResultToKotlin(getPartnerRegistrationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a partner topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Event Grid Partner Topic.
     */
    public suspend fun getPartnerTopic(argument: GetPartnerTopicPlainArgs): GetPartnerTopicResult =
        getPartnerTopicResultToKotlin(getPartnerTopicPlain(argument.toJava()).await())

    /**
     * @see [getPartnerTopic].
     * @param partnerTopicName Name of the partner topic.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Event Grid Partner Topic.
     */
    public suspend fun getPartnerTopic(partnerTopicName: String, resourceGroupName: String):
        GetPartnerTopicResult {
        val argument = GetPartnerTopicPlainArgs(
            partnerTopicName = partnerTopicName,
            resourceGroupName = resourceGroupName,
        )
        return getPartnerTopicResultToKotlin(getPartnerTopicPlain(argument.toJava()).await())
    }

    /**
     * @see [getPartnerTopic].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetPartnerTopicPlainArgs].
     * @return Event Grid Partner Topic.
     */
    public suspend fun getPartnerTopic(argument: suspend GetPartnerTopicPlainArgsBuilder.() -> Unit):
        GetPartnerTopicResult {
        val builder = GetPartnerTopicPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPartnerTopicResultToKotlin(getPartnerTopicPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of an event subscription of a partner topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Event Subscription
     */
    public suspend
    fun getPartnerTopicEventSubscription(argument: GetPartnerTopicEventSubscriptionPlainArgs):
        GetPartnerTopicEventSubscriptionResult =
        getPartnerTopicEventSubscriptionResultToKotlin(getPartnerTopicEventSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getPartnerTopicEventSubscription].
     * @param eventSubscriptionName Name of the event subscription to be found. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     * @param partnerTopicName Name of the partner topic.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Event Subscription
     */
    public suspend fun getPartnerTopicEventSubscription(
        eventSubscriptionName: String,
        partnerTopicName: String,
        resourceGroupName: String,
    ): GetPartnerTopicEventSubscriptionResult {
        val argument = GetPartnerTopicEventSubscriptionPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            partnerTopicName = partnerTopicName,
            resourceGroupName = resourceGroupName,
        )
        return getPartnerTopicEventSubscriptionResultToKotlin(getPartnerTopicEventSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPartnerTopicEventSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetPartnerTopicEventSubscriptionPlainArgs].
     * @return Event Subscription
     */
    public suspend
    fun getPartnerTopicEventSubscription(argument: suspend GetPartnerTopicEventSubscriptionPlainArgsBuilder.() -> Unit):
        GetPartnerTopicEventSubscriptionResult {
        val builder = GetPartnerTopicEventSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPartnerTopicEventSubscriptionResultToKotlin(getPartnerTopicEventSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get all delivery attributes for an event subscription of a partner topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getPartnerTopicEventSubscriptionDeliveryAttributes(argument: GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs):
        GetPartnerTopicEventSubscriptionDeliveryAttributesResult =
        getPartnerTopicEventSubscriptionDeliveryAttributesResultToKotlin(getPartnerTopicEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())

    /**
     * @see [getPartnerTopicEventSubscriptionDeliveryAttributes].
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     * @param partnerTopicName Name of the partner topic.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Result of the Get delivery attributes operation.
     */
    public suspend fun getPartnerTopicEventSubscriptionDeliveryAttributes(
        eventSubscriptionName: String,
        partnerTopicName: String,
        resourceGroupName: String,
    ): GetPartnerTopicEventSubscriptionDeliveryAttributesResult {
        val argument = GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            partnerTopicName = partnerTopicName,
            resourceGroupName = resourceGroupName,
        )
        return getPartnerTopicEventSubscriptionDeliveryAttributesResultToKotlin(getPartnerTopicEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())
    }

    /**
     * @see [getPartnerTopicEventSubscriptionDeliveryAttributes].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs].
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getPartnerTopicEventSubscriptionDeliveryAttributes(argument: suspend GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder.() -> Unit):
        GetPartnerTopicEventSubscriptionDeliveryAttributesResult {
        val builder = GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPartnerTopicEventSubscriptionDeliveryAttributesResultToKotlin(getPartnerTopicEventSubscriptionDeliveryAttributesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the full endpoint URL for an event subscription of a partner topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getPartnerTopicEventSubscriptionFullUrl(argument: GetPartnerTopicEventSubscriptionFullUrlPlainArgs):
        GetPartnerTopicEventSubscriptionFullUrlResult =
        getPartnerTopicEventSubscriptionFullUrlResultToKotlin(getPartnerTopicEventSubscriptionFullUrlPlain(argument.toJava()).await())

    /**
     * @see [getPartnerTopicEventSubscriptionFullUrl].
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     * @param partnerTopicName Name of the partner topic.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Full endpoint url of an event subscription
     */
    public suspend fun getPartnerTopicEventSubscriptionFullUrl(
        eventSubscriptionName: String,
        partnerTopicName: String,
        resourceGroupName: String,
    ): GetPartnerTopicEventSubscriptionFullUrlResult {
        val argument = GetPartnerTopicEventSubscriptionFullUrlPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            partnerTopicName = partnerTopicName,
            resourceGroupName = resourceGroupName,
        )
        return getPartnerTopicEventSubscriptionFullUrlResultToKotlin(getPartnerTopicEventSubscriptionFullUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getPartnerTopicEventSubscriptionFullUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetPartnerTopicEventSubscriptionFullUrlPlainArgs].
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getPartnerTopicEventSubscriptionFullUrl(argument: suspend GetPartnerTopicEventSubscriptionFullUrlPlainArgsBuilder.() -> Unit):
        GetPartnerTopicEventSubscriptionFullUrlResult {
        val builder = GetPartnerTopicEventSubscriptionFullUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPartnerTopicEventSubscriptionFullUrlResultToKotlin(getPartnerTopicEventSubscriptionFullUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a permission binding.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-12-15-preview.
     * @param argument null
     * @return The Permission binding resource.
     */
    public suspend fun getPermissionBinding(argument: GetPermissionBindingPlainArgs):
        GetPermissionBindingResult =
        getPermissionBindingResultToKotlin(getPermissionBindingPlain(argument.toJava()).await())

    /**
     * @see [getPermissionBinding].
     * @param namespaceName Name of the namespace.
     * @param permissionBindingName Name of the permission binding.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return The Permission binding resource.
     */
    public suspend fun getPermissionBinding(
        namespaceName: String,
        permissionBindingName: String,
        resourceGroupName: String,
    ): GetPermissionBindingResult {
        val argument = GetPermissionBindingPlainArgs(
            namespaceName = namespaceName,
            permissionBindingName = permissionBindingName,
            resourceGroupName = resourceGroupName,
        )
        return getPermissionBindingResultToKotlin(getPermissionBindingPlain(argument.toJava()).await())
    }

    /**
     * @see [getPermissionBinding].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetPermissionBindingPlainArgs].
     * @return The Permission binding resource.
     */
    public suspend
    fun getPermissionBinding(argument: suspend GetPermissionBindingPlainArgsBuilder.() -> Unit):
        GetPermissionBindingResult {
        val builder = GetPermissionBindingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPermissionBindingResultToKotlin(getPermissionBindingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific private endpoint connection under a topic, domain, or partner namespace.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param parentName The name of the parent resource (namely, either, the topic name, domain name, or partner namespace name).
     * @param parentType The type of the parent resource. This can be either \'topics\', \'domains\', or \'partnerNamespaces\'.
     * @param privateEndpointConnectionName The name of the private endpoint connection connection.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return null
     */
    public suspend fun getPrivateEndpointConnection(
        parentName: String,
        parentType: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            parentName = parentName,
            parentType = parentType,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return null
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a system topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return EventGrid System Topic.
     */
    public suspend fun getSystemTopic(argument: GetSystemTopicPlainArgs): GetSystemTopicResult =
        getSystemTopicResultToKotlin(getSystemTopicPlain(argument.toJava()).await())

    /**
     * @see [getSystemTopic].
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param systemTopicName Name of the system topic.
     * @return EventGrid System Topic.
     */
    public suspend fun getSystemTopic(resourceGroupName: String, systemTopicName: String):
        GetSystemTopicResult {
        val argument = GetSystemTopicPlainArgs(
            resourceGroupName = resourceGroupName,
            systemTopicName = systemTopicName,
        )
        return getSystemTopicResultToKotlin(getSystemTopicPlain(argument.toJava()).await())
    }

    /**
     * @see [getSystemTopic].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetSystemTopicPlainArgs].
     * @return EventGrid System Topic.
     */
    public suspend fun getSystemTopic(argument: suspend GetSystemTopicPlainArgsBuilder.() -> Unit):
        GetSystemTopicResult {
        val builder = GetSystemTopicPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSystemTopicResultToKotlin(getSystemTopicPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an event subscription.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Event Subscription
     */
    public suspend
    fun getSystemTopicEventSubscription(argument: GetSystemTopicEventSubscriptionPlainArgs):
        GetSystemTopicEventSubscriptionResult =
        getSystemTopicEventSubscriptionResultToKotlin(getSystemTopicEventSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getSystemTopicEventSubscription].
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param systemTopicName Name of the system topic.
     * @return Event Subscription
     */
    public suspend fun getSystemTopicEventSubscription(
        eventSubscriptionName: String,
        resourceGroupName: String,
        systemTopicName: String,
    ): GetSystemTopicEventSubscriptionResult {
        val argument = GetSystemTopicEventSubscriptionPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
            systemTopicName = systemTopicName,
        )
        return getSystemTopicEventSubscriptionResultToKotlin(getSystemTopicEventSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSystemTopicEventSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetSystemTopicEventSubscriptionPlainArgs].
     * @return Event Subscription
     */
    public suspend
    fun getSystemTopicEventSubscription(argument: suspend GetSystemTopicEventSubscriptionPlainArgsBuilder.() -> Unit):
        GetSystemTopicEventSubscriptionResult {
        val builder = GetSystemTopicEventSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSystemTopicEventSubscriptionResultToKotlin(getSystemTopicEventSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get all delivery attributes for an event subscription.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getSystemTopicEventSubscriptionDeliveryAttributes(argument: GetSystemTopicEventSubscriptionDeliveryAttributesPlainArgs):
        GetSystemTopicEventSubscriptionDeliveryAttributesResult =
        getSystemTopicEventSubscriptionDeliveryAttributesResultToKotlin(getSystemTopicEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())

    /**
     * @see [getSystemTopicEventSubscriptionDeliveryAttributes].
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param systemTopicName Name of the system topic.
     * @return Result of the Get delivery attributes operation.
     */
    public suspend fun getSystemTopicEventSubscriptionDeliveryAttributes(
        eventSubscriptionName: String,
        resourceGroupName: String,
        systemTopicName: String,
    ): GetSystemTopicEventSubscriptionDeliveryAttributesResult {
        val argument = GetSystemTopicEventSubscriptionDeliveryAttributesPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
            systemTopicName = systemTopicName,
        )
        return getSystemTopicEventSubscriptionDeliveryAttributesResultToKotlin(getSystemTopicEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSystemTopicEventSubscriptionDeliveryAttributes].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetSystemTopicEventSubscriptionDeliveryAttributesPlainArgs].
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getSystemTopicEventSubscriptionDeliveryAttributes(argument: suspend GetSystemTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder.() -> Unit):
        GetSystemTopicEventSubscriptionDeliveryAttributesResult {
        val builder = GetSystemTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSystemTopicEventSubscriptionDeliveryAttributesResultToKotlin(getSystemTopicEventSubscriptionDeliveryAttributesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the full endpoint URL for an event subscription of a system topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getSystemTopicEventSubscriptionFullUrl(argument: GetSystemTopicEventSubscriptionFullUrlPlainArgs):
        GetSystemTopicEventSubscriptionFullUrlResult =
        getSystemTopicEventSubscriptionFullUrlResultToKotlin(getSystemTopicEventSubscriptionFullUrlPlain(argument.toJava()).await())

    /**
     * @see [getSystemTopicEventSubscriptionFullUrl].
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param systemTopicName Name of the system topic.
     * @return Full endpoint url of an event subscription
     */
    public suspend fun getSystemTopicEventSubscriptionFullUrl(
        eventSubscriptionName: String,
        resourceGroupName: String,
        systemTopicName: String,
    ): GetSystemTopicEventSubscriptionFullUrlResult {
        val argument = GetSystemTopicEventSubscriptionFullUrlPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
            systemTopicName = systemTopicName,
        )
        return getSystemTopicEventSubscriptionFullUrlResultToKotlin(getSystemTopicEventSubscriptionFullUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getSystemTopicEventSubscriptionFullUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetSystemTopicEventSubscriptionFullUrlPlainArgs].
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getSystemTopicEventSubscriptionFullUrl(argument: suspend GetSystemTopicEventSubscriptionFullUrlPlainArgsBuilder.() -> Unit):
        GetSystemTopicEventSubscriptionFullUrlResult {
        val builder = GetSystemTopicEventSubscriptionFullUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSystemTopicEventSubscriptionFullUrlResultToKotlin(getSystemTopicEventSubscriptionFullUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2020-04-01-preview, 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return EventGrid Topic
     */
    public suspend fun getTopic(argument: GetTopicPlainArgs): GetTopicResult =
        getTopicResultToKotlin(getTopicPlain(argument.toJava()).await())

    /**
     * @see [getTopic].
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the topic.
     * @return EventGrid Topic
     */
    public suspend fun getTopic(resourceGroupName: String, topicName: String): GetTopicResult {
        val argument = GetTopicPlainArgs(
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getTopicResultToKotlin(getTopicPlain(argument.toJava()).await())
    }

    /**
     * @see [getTopic].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetTopicPlainArgs].
     * @return EventGrid Topic
     */
    public suspend fun getTopic(argument: suspend GetTopicPlainArgsBuilder.() -> Unit):
        GetTopicResult {
        val builder = GetTopicPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTopicResultToKotlin(getTopicPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of an event subscription of a topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Event Subscription
     */
    public suspend fun getTopicEventSubscription(argument: GetTopicEventSubscriptionPlainArgs):
        GetTopicEventSubscriptionResult =
        getTopicEventSubscriptionResultToKotlin(getTopicEventSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getTopicEventSubscription].
     * @param eventSubscriptionName Name of the event subscription to be found. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the partner topic.
     * @return Event Subscription
     */
    public suspend fun getTopicEventSubscription(
        eventSubscriptionName: String,
        resourceGroupName: String,
        topicName: String,
    ): GetTopicEventSubscriptionResult {
        val argument = GetTopicEventSubscriptionPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getTopicEventSubscriptionResultToKotlin(getTopicEventSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getTopicEventSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetTopicEventSubscriptionPlainArgs].
     * @return Event Subscription
     */
    public suspend
    fun getTopicEventSubscription(argument: suspend GetTopicEventSubscriptionPlainArgsBuilder.() -> Unit):
        GetTopicEventSubscriptionResult {
        val builder = GetTopicEventSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTopicEventSubscriptionResultToKotlin(getTopicEventSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get all delivery attributes for an event subscription for topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getTopicEventSubscriptionDeliveryAttributes(argument: GetTopicEventSubscriptionDeliveryAttributesPlainArgs):
        GetTopicEventSubscriptionDeliveryAttributesResult =
        getTopicEventSubscriptionDeliveryAttributesResultToKotlin(getTopicEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())

    /**
     * @see [getTopicEventSubscriptionDeliveryAttributes].
     * @param eventSubscriptionName Name of the event subscription.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the domain topic.
     * @return Result of the Get delivery attributes operation.
     */
    public suspend fun getTopicEventSubscriptionDeliveryAttributes(
        eventSubscriptionName: String,
        resourceGroupName: String,
        topicName: String,
    ): GetTopicEventSubscriptionDeliveryAttributesResult {
        val argument = GetTopicEventSubscriptionDeliveryAttributesPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getTopicEventSubscriptionDeliveryAttributesResultToKotlin(getTopicEventSubscriptionDeliveryAttributesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTopicEventSubscriptionDeliveryAttributes].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetTopicEventSubscriptionDeliveryAttributesPlainArgs].
     * @return Result of the Get delivery attributes operation.
     */
    public suspend
    fun getTopicEventSubscriptionDeliveryAttributes(argument: suspend GetTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder.() -> Unit):
        GetTopicEventSubscriptionDeliveryAttributesResult {
        val builder = GetTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTopicEventSubscriptionDeliveryAttributesResultToKotlin(getTopicEventSubscriptionDeliveryAttributesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the full endpoint URL for an event subscription for topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getTopicEventSubscriptionFullUrl(argument: GetTopicEventSubscriptionFullUrlPlainArgs):
        GetTopicEventSubscriptionFullUrlResult =
        getTopicEventSubscriptionFullUrlResultToKotlin(getTopicEventSubscriptionFullUrlPlain(argument.toJava()).await())

    /**
     * @see [getTopicEventSubscriptionFullUrl].
     * @param eventSubscriptionName Name of the event subscription.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the domain topic.
     * @return Full endpoint url of an event subscription
     */
    public suspend fun getTopicEventSubscriptionFullUrl(
        eventSubscriptionName: String,
        resourceGroupName: String,
        topicName: String,
    ): GetTopicEventSubscriptionFullUrlResult {
        val argument = GetTopicEventSubscriptionFullUrlPlainArgs(
            eventSubscriptionName = eventSubscriptionName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return getTopicEventSubscriptionFullUrlResultToKotlin(getTopicEventSubscriptionFullUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getTopicEventSubscriptionFullUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetTopicEventSubscriptionFullUrlPlainArgs].
     * @return Full endpoint url of an event subscription
     */
    public suspend
    fun getTopicEventSubscriptionFullUrl(argument: suspend GetTopicEventSubscriptionFullUrlPlainArgsBuilder.() -> Unit):
        GetTopicEventSubscriptionFullUrlResult {
        val builder = GetTopicEventSubscriptionFullUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTopicEventSubscriptionFullUrlResultToKotlin(getTopicEventSubscriptionFullUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of a topic space.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-12-15-preview.
     * @param argument null
     * @return The Topic space resource.
     */
    public suspend fun getTopicSpace(argument: GetTopicSpacePlainArgs): GetTopicSpaceResult =
        getTopicSpaceResultToKotlin(getTopicSpacePlain(argument.toJava()).await())

    /**
     * @see [getTopicSpace].
     * @param namespaceName Name of the namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicSpaceName Name of the Topic space.
     * @return The Topic space resource.
     */
    public suspend fun getTopicSpace(
        namespaceName: String,
        resourceGroupName: String,
        topicSpaceName: String,
    ): GetTopicSpaceResult {
        val argument = GetTopicSpacePlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            topicSpaceName = topicSpaceName,
        )
        return getTopicSpaceResultToKotlin(getTopicSpacePlain(argument.toJava()).await())
    }

    /**
     * @see [getTopicSpace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;GetTopicSpacePlainArgs].
     * @return The Topic space resource.
     */
    public suspend fun getTopicSpace(argument: suspend GetTopicSpacePlainArgsBuilder.() -> Unit):
        GetTopicSpaceResult {
        val builder = GetTopicSpacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTopicSpaceResultToKotlin(getTopicSpacePlain(builtArgument.toJava()).await())
    }

    /**
     * List the two keys used to publish to a domain.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2020-04-01-preview, 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Shared access keys of the Domain.
     */
    public suspend fun listDomainSharedAccessKeys(argument: ListDomainSharedAccessKeysPlainArgs):
        ListDomainSharedAccessKeysResult =
        listDomainSharedAccessKeysResultToKotlin(listDomainSharedAccessKeysPlain(argument.toJava()).await())

    /**
     * @see [listDomainSharedAccessKeys].
     * @param domainName Name of the domain.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Shared access keys of the Domain.
     */
    public suspend fun listDomainSharedAccessKeys(domainName: String, resourceGroupName: String):
        ListDomainSharedAccessKeysResult {
        val argument = ListDomainSharedAccessKeysPlainArgs(
            domainName = domainName,
            resourceGroupName = resourceGroupName,
        )
        return listDomainSharedAccessKeysResultToKotlin(listDomainSharedAccessKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listDomainSharedAccessKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;ListDomainSharedAccessKeysPlainArgs].
     * @return Shared access keys of the Domain.
     */
    public suspend
    fun listDomainSharedAccessKeys(argument: suspend ListDomainSharedAccessKeysPlainArgsBuilder.() -> Unit):
        ListDomainSharedAccessKeysResult {
        val builder = ListDomainSharedAccessKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDomainSharedAccessKeysResultToKotlin(listDomainSharedAccessKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * List the two keys used to publish to a namespace.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-12-15-preview.
     * @param argument null
     * @return Shared access keys of the Namespace.
     */
    public suspend
    fun listNamespaceSharedAccessKeys(argument: ListNamespaceSharedAccessKeysPlainArgs):
        ListNamespaceSharedAccessKeysResult =
        listNamespaceSharedAccessKeysResultToKotlin(listNamespaceSharedAccessKeysPlain(argument.toJava()).await())

    /**
     * @see [listNamespaceSharedAccessKeys].
     * @param namespaceName Name of the namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Shared access keys of the Namespace.
     */
    public suspend fun listNamespaceSharedAccessKeys(
        namespaceName: String,
        resourceGroupName: String,
    ): ListNamespaceSharedAccessKeysResult {
        val argument = ListNamespaceSharedAccessKeysPlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return listNamespaceSharedAccessKeysResultToKotlin(listNamespaceSharedAccessKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listNamespaceSharedAccessKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;ListNamespaceSharedAccessKeysPlainArgs].
     * @return Shared access keys of the Namespace.
     */
    public suspend
    fun listNamespaceSharedAccessKeys(argument: suspend ListNamespaceSharedAccessKeysPlainArgsBuilder.() -> Unit):
        ListNamespaceSharedAccessKeysResult {
        val builder = ListNamespaceSharedAccessKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listNamespaceSharedAccessKeysResultToKotlin(listNamespaceSharedAccessKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * List the two keys used to publish to a namespace topic.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-12-15-preview.
     * @param argument null
     * @return Shared access keys of the Topic
     */
    public suspend
    fun listNamespaceTopicSharedAccessKeys(argument: ListNamespaceTopicSharedAccessKeysPlainArgs):
        ListNamespaceTopicSharedAccessKeysResult =
        listNamespaceTopicSharedAccessKeysResultToKotlin(listNamespaceTopicSharedAccessKeysPlain(argument.toJava()).await())

    /**
     * @see [listNamespaceTopicSharedAccessKeys].
     * @param namespaceName Name of the namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the topic.
     * @return Shared access keys of the Topic
     */
    public suspend fun listNamespaceTopicSharedAccessKeys(
        namespaceName: String,
        resourceGroupName: String,
        topicName: String,
    ): ListNamespaceTopicSharedAccessKeysResult {
        val argument = ListNamespaceTopicSharedAccessKeysPlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return listNamespaceTopicSharedAccessKeysResultToKotlin(listNamespaceTopicSharedAccessKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listNamespaceTopicSharedAccessKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;ListNamespaceTopicSharedAccessKeysPlainArgs].
     * @return Shared access keys of the Topic
     */
    public suspend
    fun listNamespaceTopicSharedAccessKeys(argument: suspend ListNamespaceTopicSharedAccessKeysPlainArgsBuilder.() -> Unit):
        ListNamespaceTopicSharedAccessKeysResult {
        val builder = ListNamespaceTopicSharedAccessKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listNamespaceTopicSharedAccessKeysResultToKotlin(listNamespaceTopicSharedAccessKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * List the two keys used to publish to a partner namespace.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Shared access keys of the partner namespace.
     */
    public suspend
    fun listPartnerNamespaceSharedAccessKeys(argument: ListPartnerNamespaceSharedAccessKeysPlainArgs):
        ListPartnerNamespaceSharedAccessKeysResult =
        listPartnerNamespaceSharedAccessKeysResultToKotlin(listPartnerNamespaceSharedAccessKeysPlain(argument.toJava()).await())

    /**
     * @see [listPartnerNamespaceSharedAccessKeys].
     * @param partnerNamespaceName Name of the partner namespace.
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @return Shared access keys of the partner namespace.
     */
    public suspend fun listPartnerNamespaceSharedAccessKeys(
        partnerNamespaceName: String,
        resourceGroupName: String,
    ): ListPartnerNamespaceSharedAccessKeysResult {
        val argument = ListPartnerNamespaceSharedAccessKeysPlainArgs(
            partnerNamespaceName = partnerNamespaceName,
            resourceGroupName = resourceGroupName,
        )
        return listPartnerNamespaceSharedAccessKeysResultToKotlin(listPartnerNamespaceSharedAccessKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listPartnerNamespaceSharedAccessKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;ListPartnerNamespaceSharedAccessKeysPlainArgs].
     * @return Shared access keys of the partner namespace.
     */
    public suspend
    fun listPartnerNamespaceSharedAccessKeys(argument: suspend ListPartnerNamespaceSharedAccessKeysPlainArgsBuilder.() -> Unit):
        ListPartnerNamespaceSharedAccessKeysResult {
        val builder = ListPartnerNamespaceSharedAccessKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listPartnerNamespaceSharedAccessKeysResultToKotlin(listPartnerNamespaceSharedAccessKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * List the two keys used to publish to a topic.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2020-04-01-preview, 2023-06-01-preview, 2023-12-15-preview.
     * @param argument null
     * @return Shared access keys of the Topic
     */
    public suspend fun listTopicSharedAccessKeys(argument: ListTopicSharedAccessKeysPlainArgs):
        ListTopicSharedAccessKeysResult =
        listTopicSharedAccessKeysResultToKotlin(listTopicSharedAccessKeysPlain(argument.toJava()).await())

    /**
     * @see [listTopicSharedAccessKeys].
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param topicName Name of the topic.
     * @return Shared access keys of the Topic
     */
    public suspend fun listTopicSharedAccessKeys(resourceGroupName: String, topicName: String):
        ListTopicSharedAccessKeysResult {
        val argument = ListTopicSharedAccessKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            topicName = topicName,
        )
        return listTopicSharedAccessKeysResultToKotlin(listTopicSharedAccessKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listTopicSharedAccessKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventgrid&#46;kotlin&#46;inputs&#46;ListTopicSharedAccessKeysPlainArgs].
     * @return Shared access keys of the Topic
     */
    public suspend
    fun listTopicSharedAccessKeys(argument: suspend ListTopicSharedAccessKeysPlainArgsBuilder.() -> Unit):
        ListTopicSharedAccessKeysResult {
        val builder = ListTopicSharedAccessKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listTopicSharedAccessKeysResultToKotlin(listTopicSharedAccessKeysPlain(builtArgument.toJava()).await())
    }
}
