@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NamespaceTopic].
 */
@PulumiTagMarker
public class NamespaceTopicResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceTopicArgs = NamespaceTopicArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceTopicArgsBuilder.() -> Unit) {
        val builder = NamespaceTopicArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NamespaceTopic {
        val builtJavaResource = com.pulumi.azurenative.eventgrid.NamespaceTopic(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NamespaceTopic(builtJavaResource)
    }
}

/**
 * Namespace topic details.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### NamespaceTopics_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceTopic = new AzureNative.EventGrid.NamespaceTopic("namespaceTopic", new()
 *     {
 *         EventRetentionInDays = 1,
 *         InputSchema = "CloudEventSchemaV1_0",
 *         NamespaceName = "examplenamespace2",
 *         PublisherType = "Custom",
 *         ResourceGroupName = "examplerg",
 *         TopicName = "examplenamespacetopic2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewNamespaceTopic(ctx, "namespaceTopic", &eventgrid.NamespaceTopicArgs{
 * 			EventRetentionInDays: pulumi.Int(1),
 * 			InputSchema:          pulumi.String("CloudEventSchemaV1_0"),
 * 			NamespaceName:        pulumi.String("examplenamespace2"),
 * 			PublisherType:        pulumi.String("Custom"),
 * 			ResourceGroupName:    pulumi.String("examplerg"),
 * 			TopicName:            pulumi.String("examplenamespacetopic2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.NamespaceTopic;
 * import com.pulumi.azurenative.eventgrid.NamespaceTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceTopic = new NamespaceTopic("namespaceTopic", NamespaceTopicArgs.builder()
 *             .eventRetentionInDays(1)
 *             .inputSchema("CloudEventSchemaV1_0")
 *             .namespaceName("examplenamespace2")
 *             .publisherType("Custom")
 *             .resourceGroupName("examplerg")
 *             .topicName("examplenamespacetopic2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:NamespaceTopic examplenamespacetopic2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}
 * ```
 */
public class NamespaceTopic internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.NamespaceTopic,
) : KotlinCustomResource(javaResource, NamespaceTopicMapper) {
    /**
     * Event retention for the namespace topic expressed in days. The property default value is 1 day.
     * Min event retention duration value is 1 day and max event retention duration value is 1 day.
     */
    public val eventRetentionInDays: Output<Int>?
        get() = javaResource.eventRetentionInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This determines the format that is expected for incoming events published to the topic.
     */
    public val inputSchema: Output<String>?
        get() = javaResource.inputSchema().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the namespace topic.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Publisher type of the namespace topic.
     */
    public val publisherType: Output<String>?
        get() = javaResource.publisherType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to namespace topic resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NamespaceTopicMapper : ResourceMapper<NamespaceTopic> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.NamespaceTopic::class == javaResource::class

    override fun map(javaResource: Resource): NamespaceTopic = NamespaceTopic(
        javaResource as
            com.pulumi.azurenative.eventgrid.NamespaceTopic,
    )
}

/**
 * @see [NamespaceTopic].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NamespaceTopic].
 */
public suspend fun namespaceTopic(
    name: String,
    block: suspend NamespaceTopicResourceBuilder.() -> Unit,
): NamespaceTopic {
    val builder = NamespaceTopicResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NamespaceTopic].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespaceTopic(name: String): NamespaceTopic {
    val builder = NamespaceTopicResourceBuilder()
    builder.name(name)
    return builder.build()
}
