@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.PartnerDestinationArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.PartnerDestinationActivationState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Event Grid Partner Destination.
 * Azure REST API version: 2023-06-01-preview. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2021-10-15-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### PartnerDestinations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partnerDestination = new AzureNative.EventGrid.PartnerDestination("partnerDestination", new()
 *     {
 *         EndpointBaseUrl = "https://www.example/endpoint",
 *         EndpointServiceContext = "This is an example",
 *         ExpirationTimeIfNotActivatedUtc = "2022-03-14T19:33:43.430Z",
 *         Location = "westus2",
 *         MessageForActivation = "Sample Activation message",
 *         PartnerDestinationName = "examplePartnerDestinationName1",
 *         PartnerRegistrationImmutableId = "0bd70ee2-7d95-447e-ab1f-c4f320019404",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPartnerDestination(ctx, "partnerDestination", &eventgrid.PartnerDestinationArgs{
 * 			EndpointBaseUrl:                 pulumi.String("https://www.example/endpoint"),
 * 			EndpointServiceContext:          pulumi.String("This is an example"),
 * 			ExpirationTimeIfNotActivatedUtc: pulumi.String("2022-03-14T19:33:43.430Z"),
 * 			Location:                        pulumi.String("westus2"),
 * 			MessageForActivation:            pulumi.String("Sample Activation message"),
 * 			PartnerDestinationName:          pulumi.String("examplePartnerDestinationName1"),
 * 			PartnerRegistrationImmutableId:  pulumi.String("0bd70ee2-7d95-447e-ab1f-c4f320019404"),
 * 			ResourceGroupName:               pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PartnerDestination;
 * import com.pulumi.azurenative.eventgrid.PartnerDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partnerDestination = new PartnerDestination("partnerDestination", PartnerDestinationArgs.builder()
 *             .endpointBaseUrl("https://www.example/endpoint")
 *             .endpointServiceContext("This is an example")
 *             .expirationTimeIfNotActivatedUtc("2022-03-14T19:33:43.430Z")
 *             .location("westus2")
 *             .messageForActivation("Sample Activation message")
 *             .partnerDestinationName("examplePartnerDestinationName1")
 *             .partnerRegistrationImmutableId("0bd70ee2-7d95-447e-ab1f-c4f320019404")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PartnerDestination examplePartnerDestinationName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerDestinations/{partnerDestinationName}
 * ```
 * @property activationState Activation state of the partner destination.
 * @property endpointBaseUrl Endpoint Base URL of the partner destination
 * @property endpointServiceContext Endpoint context associated with this partner destination.
 * @property expirationTimeIfNotActivatedUtc Expiration time of the partner destination. If this timer expires and the partner destination was never activated,
 * the partner destination and corresponding channel are deleted.
 * @property location Location of the resource.
 * @property messageForActivation Context or helpful message that can be used during the approval process.
 * @property partnerDestinationName Name of the partner destination.
 * @property partnerRegistrationImmutableId The immutable Id of the corresponding partner registration.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property tags Tags of the resource.
 */
public data class PartnerDestinationArgs(
    public val activationState: Output<Either<String, PartnerDestinationActivationState>>? = null,
    public val endpointBaseUrl: Output<String>? = null,
    public val endpointServiceContext: Output<String>? = null,
    public val expirationTimeIfNotActivatedUtc: Output<String>? = null,
    public val location: Output<String>? = null,
    public val messageForActivation: Output<String>? = null,
    public val partnerDestinationName: Output<String>? = null,
    public val partnerRegistrationImmutableId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.PartnerDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.PartnerDestinationArgs =
        com.pulumi.azurenative.eventgrid.PartnerDestinationArgs.builder()
            .activationState(
                activationState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointBaseUrl(endpointBaseUrl?.applyValue({ args0 -> args0 }))
            .endpointServiceContext(endpointServiceContext?.applyValue({ args0 -> args0 }))
            .expirationTimeIfNotActivatedUtc(expirationTimeIfNotActivatedUtc?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .messageForActivation(messageForActivation?.applyValue({ args0 -> args0 }))
            .partnerDestinationName(partnerDestinationName?.applyValue({ args0 -> args0 }))
            .partnerRegistrationImmutableId(partnerRegistrationImmutableId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PartnerDestinationArgs].
 */
@PulumiTagMarker
public class PartnerDestinationArgsBuilder internal constructor() {
    private var activationState: Output<Either<String, PartnerDestinationActivationState>>? = null

    private var endpointBaseUrl: Output<String>? = null

    private var endpointServiceContext: Output<String>? = null

    private var expirationTimeIfNotActivatedUtc: Output<String>? = null

    private var location: Output<String>? = null

    private var messageForActivation: Output<String>? = null

    private var partnerDestinationName: Output<String>? = null

    private var partnerRegistrationImmutableId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Activation state of the partner destination.
     */
    @JvmName("scfdjwmqreuquwiw")
    public suspend
    fun activationState(`value`: Output<Either<String, PartnerDestinationActivationState>>) {
        this.activationState = value
    }

    /**
     * @param value Endpoint Base URL of the partner destination
     */
    @JvmName("hpifajdrebfeiccc")
    public suspend fun endpointBaseUrl(`value`: Output<String>) {
        this.endpointBaseUrl = value
    }

    /**
     * @param value Endpoint context associated with this partner destination.
     */
    @JvmName("scwteprjhhnqoaar")
    public suspend fun endpointServiceContext(`value`: Output<String>) {
        this.endpointServiceContext = value
    }

    /**
     * @param value Expiration time of the partner destination. If this timer expires and the partner destination was never activated,
     * the partner destination and corresponding channel are deleted.
     */
    @JvmName("bxvsjvxqnpjyydhu")
    public suspend fun expirationTimeIfNotActivatedUtc(`value`: Output<String>) {
        this.expirationTimeIfNotActivatedUtc = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("gyoqhwpxoamddqyw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Context or helpful message that can be used during the approval process.
     */
    @JvmName("ccbqhsaiiojcbtie")
    public suspend fun messageForActivation(`value`: Output<String>) {
        this.messageForActivation = value
    }

    /**
     * @param value Name of the partner destination.
     */
    @JvmName("moifweelyuwcgrue")
    public suspend fun partnerDestinationName(`value`: Output<String>) {
        this.partnerDestinationName = value
    }

    /**
     * @param value The immutable Id of the corresponding partner registration.
     */
    @JvmName("eolgkjgqmhvquana")
    public suspend fun partnerRegistrationImmutableId(`value`: Output<String>) {
        this.partnerRegistrationImmutableId = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("vasvslembaqwatit")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("cwalbycpxahvnron")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Activation state of the partner destination.
     */
    @JvmName("cohrkjimrxonmrab")
    public suspend fun activationState(`value`: Either<String, PartnerDestinationActivationState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activationState = mapped
    }

    /**
     * @param value Activation state of the partner destination.
     */
    @JvmName("helwiohnqswnioqm")
    public fun activationState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PartnerDestinationActivationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activationState = mapped
    }

    /**
     * @param value Activation state of the partner destination.
     */
    @JvmName("ojatpstkxcawwvpi")
    public fun activationState(`value`: PartnerDestinationActivationState) {
        val toBeMapped = Either.ofRight<String, PartnerDestinationActivationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activationState = mapped
    }

    /**
     * @param value Endpoint Base URL of the partner destination
     */
    @JvmName("bopahgemlbcqhkud")
    public suspend fun endpointBaseUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointBaseUrl = mapped
    }

    /**
     * @param value Endpoint context associated with this partner destination.
     */
    @JvmName("ftpmkiqfwawfdupw")
    public suspend fun endpointServiceContext(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointServiceContext = mapped
    }

    /**
     * @param value Expiration time of the partner destination. If this timer expires and the partner destination was never activated,
     * the partner destination and corresponding channel are deleted.
     */
    @JvmName("xsnagdqjqyekxqaj")
    public suspend fun expirationTimeIfNotActivatedUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationTimeIfNotActivatedUtc = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("xedfjqtyyptohsxl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Context or helpful message that can be used during the approval process.
     */
    @JvmName("oqhycwmludqvolsm")
    public suspend fun messageForActivation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageForActivation = mapped
    }

    /**
     * @param value Name of the partner destination.
     */
    @JvmName("nomdipwswgpgjfvb")
    public suspend fun partnerDestinationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerDestinationName = mapped
    }

    /**
     * @param value The immutable Id of the corresponding partner registration.
     */
    @JvmName("ytfpmhtcbqvwktus")
    public suspend fun partnerRegistrationImmutableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerRegistrationImmutableId = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("oxtwgtoqlqwdlfwq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("ebvxrkutlyguyfib")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the resource.
     */
    @JvmName("uisrllurprqmjgxw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PartnerDestinationArgs = PartnerDestinationArgs(
        activationState = activationState,
        endpointBaseUrl = endpointBaseUrl,
        endpointServiceContext = endpointServiceContext,
        expirationTimeIfNotActivatedUtc = expirationTimeIfNotActivatedUtc,
        location = location,
        messageForActivation = messageForActivation,
        partnerDestinationName = partnerDestinationName,
        partnerRegistrationImmutableId = partnerRegistrationImmutableId,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
