@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.PartnerNamespaceArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.PartnerTopicRoutingMode
import com.pulumi.azurenative.eventgrid.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.eventgrid.kotlin.inputs.InboundIpRuleArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.InboundIpRuleArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * EventGrid Partner Namespace.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### PartnerNamespaces_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partnerNamespace = new AzureNative.EventGrid.PartnerNamespace("partnerNamespace", new()
 *     {
 *         Location = "westus",
 *         PartnerNamespaceName = "examplePartnerNamespaceName1",
 *         PartnerRegistrationFullyQualifiedId = "/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/partnerRegistrations/ContosoCorpAccount1",
 *         ResourceGroupName = "examplerg",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPartnerNamespace(ctx, "partnerNamespace", &eventgrid.PartnerNamespaceArgs{
 * 			Location:                            pulumi.String("westus"),
 * 			PartnerNamespaceName:                pulumi.String("examplePartnerNamespaceName1"),
 * 			PartnerRegistrationFullyQualifiedId: pulumi.String("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/partnerRegistrations/ContosoCorpAccount1"),
 * 			ResourceGroupName:                   pulumi.String("examplerg"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PartnerNamespace;
 * import com.pulumi.azurenative.eventgrid.PartnerNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partnerNamespace = new PartnerNamespace("partnerNamespace", PartnerNamespaceArgs.builder()
 *             .location("westus")
 *             .partnerNamespaceName("examplePartnerNamespaceName1")
 *             .partnerRegistrationFullyQualifiedId("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/partnerRegistrations/ContosoCorpAccount1")
 *             .resourceGroupName("examplerg")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PartnerNamespace examplePartnerNamespaceName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}
 * ```
 * @property disableLocalAuth This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the partner namespace.
 * @property inboundIpRules This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
 * @property location Location of the resource.
 * @property partnerNamespaceName Name of the partner namespace.
 * @property partnerRegistrationFullyQualifiedId The fully qualified ARM Id of the partner registration that should be associated with this partner namespace. This takes the following format:
 * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.
 * @property partnerTopicRoutingMode This determines if events published to this partner namespace should use the source attribute in the event payload
 * or use the channel name in the header when matching to the partner topic. If none is specified, source attribute routing will be used to match the partner topic.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceProperties.InboundIpRules" />
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property tags Tags of the resource.
 */
public data class PartnerNamespaceArgs(
    public val disableLocalAuth: Output<Boolean>? = null,
    public val inboundIpRules: Output<List<InboundIpRuleArgs>>? = null,
    public val location: Output<String>? = null,
    public val partnerNamespaceName: Output<String>? = null,
    public val partnerRegistrationFullyQualifiedId: Output<String>? = null,
    public val partnerTopicRoutingMode: Output<Either<String, PartnerTopicRoutingMode>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.PartnerNamespaceArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.PartnerNamespaceArgs =
        com.pulumi.azurenative.eventgrid.PartnerNamespaceArgs.builder()
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .inboundIpRules(
                inboundIpRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .partnerNamespaceName(partnerNamespaceName?.applyValue({ args0 -> args0 }))
            .partnerRegistrationFullyQualifiedId(
                partnerRegistrationFullyQualifiedId?.applyValue({ args0 ->
                    args0
                }),
            )
            .partnerTopicRoutingMode(
                partnerTopicRoutingMode?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PartnerNamespaceArgs].
 */
@PulumiTagMarker
public class PartnerNamespaceArgsBuilder internal constructor() {
    private var disableLocalAuth: Output<Boolean>? = null

    private var inboundIpRules: Output<List<InboundIpRuleArgs>>? = null

    private var location: Output<String>? = null

    private var partnerNamespaceName: Output<String>? = null

    private var partnerRegistrationFullyQualifiedId: Output<String>? = null

    private var partnerTopicRoutingMode: Output<Either<String, PartnerTopicRoutingMode>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the partner namespace.
     */
    @JvmName("igbbpdplqkldqbik")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("eyvjsvogmtodltvd")
    public suspend fun inboundIpRules(`value`: Output<List<InboundIpRuleArgs>>) {
        this.inboundIpRules = value
    }

    @JvmName("hyspocubgbnoyqej")
    public suspend fun inboundIpRules(vararg values: Output<InboundIpRuleArgs>) {
        this.inboundIpRules = Output.all(values.asList())
    }

    /**
     * @param values This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("ewuwkkfqudofialx")
    public suspend fun inboundIpRules(values: List<Output<InboundIpRuleArgs>>) {
        this.inboundIpRules = Output.all(values)
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("qunwdlqnxrjpqnuh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the partner namespace.
     */
    @JvmName("nstopvbxfcwxeivy")
    public suspend fun partnerNamespaceName(`value`: Output<String>) {
        this.partnerNamespaceName = value
    }

    /**
     * @param value The fully qualified ARM Id of the partner registration that should be associated with this partner namespace. This takes the following format:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.
     */
    @JvmName("ttadghjysbygxlen")
    public suspend fun partnerRegistrationFullyQualifiedId(`value`: Output<String>) {
        this.partnerRegistrationFullyQualifiedId = value
    }

    /**
     * @param value This determines if events published to this partner namespace should use the source attribute in the event payload
     * or use the channel name in the header when matching to the partner topic. If none is specified, source attribute routing will be used to match the partner topic.
     */
    @JvmName("ysxfplqurisdrfst")
    public suspend
    fun partnerTopicRoutingMode(`value`: Output<Either<String, PartnerTopicRoutingMode>>) {
        this.partnerTopicRoutingMode = value
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceProperties.InboundIpRules" />
     */
    @JvmName("melepafdkdvvhcyb")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("wnvaehkdgrlapuif")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("jlvnfpgkxuxanfsa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the partner namespace.
     */
    @JvmName("vcdutnkfeowobrdx")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("dqbxuppmgmyoffin")
    public suspend fun inboundIpRules(`value`: List<InboundIpRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("bexspthnmpslmgte")
    public suspend fun inboundIpRules(argument: List<suspend InboundIpRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundIpRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("vgndphjldurydvei")
    public suspend fun inboundIpRules(vararg argument: suspend InboundIpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InboundIpRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("aepgdyrlgltqnkbd")
    public suspend fun inboundIpRules(argument: suspend InboundIpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InboundIpRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param values This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("skvysslswgorhfmf")
    public suspend fun inboundIpRules(vararg values: InboundIpRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inboundIpRules = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("pybhqxbdmtobspkl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the partner namespace.
     */
    @JvmName("xfmspsadboqovqbc")
    public suspend fun partnerNamespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerNamespaceName = mapped
    }

    /**
     * @param value The fully qualified ARM Id of the partner registration that should be associated with this partner namespace. This takes the following format:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.
     */
    @JvmName("xmxkoapocmgjjjtu")
    public suspend fun partnerRegistrationFullyQualifiedId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerRegistrationFullyQualifiedId = mapped
    }

    /**
     * @param value This determines if events published to this partner namespace should use the source attribute in the event payload
     * or use the channel name in the header when matching to the partner topic. If none is specified, source attribute routing will be used to match the partner topic.
     */
    @JvmName("bidjmiawotdcxfop")
    public suspend fun partnerTopicRoutingMode(`value`: Either<String, PartnerTopicRoutingMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerTopicRoutingMode = mapped
    }

    /**
     * @param value This determines if events published to this partner namespace should use the source attribute in the event payload
     * or use the channel name in the header when matching to the partner topic. If none is specified, source attribute routing will be used to match the partner topic.
     */
    @JvmName("cmrcbwcslqfmeivd")
    public fun partnerTopicRoutingMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PartnerTopicRoutingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerTopicRoutingMode = mapped
    }

    /**
     * @param value This determines if events published to this partner namespace should use the source attribute in the event payload
     * or use the channel name in the header when matching to the partner topic. If none is specified, source attribute routing will be used to match the partner topic.
     */
    @JvmName("ktytfmtkpydmkjcw")
    public fun partnerTopicRoutingMode(`value`: PartnerTopicRoutingMode) {
        val toBeMapped = Either.ofRight<String, PartnerTopicRoutingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerTopicRoutingMode = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceProperties.InboundIpRules" />
     */
    @JvmName("tuffiwhdahghjnsg")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceProperties.InboundIpRules" />
     */
    @JvmName("jmnodseyhffbnmsb")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceProperties.InboundIpRules" />
     */
    @JvmName("wfpewboilkrjopgw")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("egephqgxuldiplru")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("grinmgtrvawnhkqp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the resource.
     */
    @JvmName("juvdgqchmyfnywrx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PartnerNamespaceArgs = PartnerNamespaceArgs(
        disableLocalAuth = disableLocalAuth,
        inboundIpRules = inboundIpRules,
        location = location,
        partnerNamespaceName = partnerNamespaceName,
        partnerRegistrationFullyQualifiedId = partnerRegistrationFullyQualifiedId,
        partnerTopicRoutingMode = partnerTopicRoutingMode,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
