@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.EventTypeInfoResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.eventgrid.kotlin.outputs.EventTypeInfoResponse.Companion.toKotlin as eventTypeInfoResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse.Companion.toKotlin as identityInfoResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PartnerTopic].
 */
@PulumiTagMarker
public class PartnerTopicResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PartnerTopicArgs = PartnerTopicArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PartnerTopicArgsBuilder.() -> Unit) {
        val builder = PartnerTopicArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PartnerTopic {
        val builtJavaResource = com.pulumi.azurenative.eventgrid.PartnerTopic(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PartnerTopic(builtJavaResource)
    }
}

/**
 * Event Grid Partner Topic.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### PartnerTopics_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partnerTopic = new AzureNative.EventGrid.PartnerTopic("partnerTopic", new()
 *     {
 *         ExpirationTimeIfNotActivatedUtc = "2022-03-23T23:06:13.109Z",
 *         Location = "westus2",
 *         MessageForActivation = "Example message for activation",
 *         PartnerRegistrationImmutableId = "6f541064-031d-4cc8-9ec3-a3b4fc0f7185",
 *         PartnerTopicFriendlyDescription = "Example description",
 *         PartnerTopicName = "examplePartnerTopicName1",
 *         ResourceGroupName = "examplerg",
 *         Source = "ContosoCorp.Accounts.User1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPartnerTopic(ctx, "partnerTopic", &eventgrid.PartnerTopicArgs{
 * 			ExpirationTimeIfNotActivatedUtc: pulumi.String("2022-03-23T23:06:13.109Z"),
 * 			Location:                        pulumi.String("westus2"),
 * 			MessageForActivation:            pulumi.String("Example message for activation"),
 * 			PartnerRegistrationImmutableId:  pulumi.String("6f541064-031d-4cc8-9ec3-a3b4fc0f7185"),
 * 			PartnerTopicFriendlyDescription: pulumi.String("Example description"),
 * 			PartnerTopicName:                pulumi.String("examplePartnerTopicName1"),
 * 			ResourceGroupName:               pulumi.String("examplerg"),
 * 			Source:                          pulumi.String("ContosoCorp.Accounts.User1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PartnerTopic;
 * import com.pulumi.azurenative.eventgrid.PartnerTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partnerTopic = new PartnerTopic("partnerTopic", PartnerTopicArgs.builder()
 *             .expirationTimeIfNotActivatedUtc("2022-03-23T23:06:13.109Z")
 *             .location("westus2")
 *             .messageForActivation("Example message for activation")
 *             .partnerRegistrationImmutableId("6f541064-031d-4cc8-9ec3-a3b4fc0f7185")
 *             .partnerTopicFriendlyDescription("Example description")
 *             .partnerTopicName("examplePartnerTopicName1")
 *             .resourceGroupName("examplerg")
 *             .source("ContosoCorp.Accounts.User1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PartnerTopic examplePartnerTopicName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerTopics/{partnerTopicName}
 * ```
 */
public class PartnerTopic internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.PartnerTopic,
) : KotlinCustomResource(javaResource, PartnerTopicMapper) {
    /**
     * Activation state of the partner topic.
     */
    public val activationState: Output<String>?
        get() = javaResource.activationState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Event Type information from the corresponding event channel.
     */
    public val eventTypeInfo: Output<EventTypeInfoResponse>?
        get() = javaResource.eventTypeInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventTypeInfoResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Expiration time of the partner topic. If this timer expires while the partner topic is still never activated,
     * the partner topic and corresponding event channel are deleted.
     */
    public val expirationTimeIfNotActivatedUtc: Output<String>?
        get() = javaResource.expirationTimeIfNotActivatedUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identity information for the Partner Topic resource.
     */
    public val identity: Output<IdentityInfoResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Context or helpful message that can be used during the approval process by the subscriber.
     */
    public val messageForActivation: Output<String>?
        get() = javaResource.messageForActivation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The immutableId of the corresponding partner registration.
     */
    public val partnerRegistrationImmutableId: Output<String>?
        get() = javaResource.partnerRegistrationImmutableId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer partner topic.
     * This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
     */
    public val partnerTopicFriendlyDescription: Output<String>?
        get() = javaResource.partnerTopicFriendlyDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the partner topic.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Source associated with this partner topic. This represents a unique partner resource.
     */
    public val source: Output<String>?
        get() = javaResource.source().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system metadata relating to Partner Topic resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PartnerTopicMapper : ResourceMapper<PartnerTopic> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.PartnerTopic::class == javaResource::class

    override fun map(javaResource: Resource): PartnerTopic = PartnerTopic(
        javaResource as
            com.pulumi.azurenative.eventgrid.PartnerTopic,
    )
}

/**
 * @see [PartnerTopic].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PartnerTopic].
 */
public suspend fun partnerTopic(
    name: String,
    block: suspend PartnerTopicResourceBuilder.() -> Unit,
): PartnerTopic {
    val builder = PartnerTopicResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PartnerTopic].
 * @param name The _unique_ name of the resulting resource.
 */
public fun partnerTopic(name: String): PartnerTopic {
    val builder = PartnerTopicResourceBuilder()
    builder.name(name)
    return builder.build()
}
