@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.PermissionBindingArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.PermissionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Permission binding resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### PermissionBindings_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var permissionBinding = new AzureNative.EventGrid.PermissionBinding("permissionBinding", new()
 *     {
 *         ClientGroupName = "exampleClientGroupName1",
 *         NamespaceName = "exampleNamespaceName1",
 *         Permission = "Publisher",
 *         PermissionBindingName = "examplePermissionBindingName1",
 *         ResourceGroupName = "examplerg",
 *         TopicSpaceName = "exampleTopicSpaceName1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPermissionBinding(ctx, "permissionBinding", &eventgrid.PermissionBindingArgs{
 * 			ClientGroupName:       pulumi.String("exampleClientGroupName1"),
 * 			NamespaceName:         pulumi.String("exampleNamespaceName1"),
 * 			Permission:            pulumi.String("Publisher"),
 * 			PermissionBindingName: pulumi.String("examplePermissionBindingName1"),
 * 			ResourceGroupName:     pulumi.String("examplerg"),
 * 			TopicSpaceName:        pulumi.String("exampleTopicSpaceName1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PermissionBinding;
 * import com.pulumi.azurenative.eventgrid.PermissionBindingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var permissionBinding = new PermissionBinding("permissionBinding", PermissionBindingArgs.builder()
 *             .clientGroupName("exampleClientGroupName1")
 *             .namespaceName("exampleNamespaceName1")
 *             .permission("Publisher")
 *             .permissionBindingName("examplePermissionBindingName1")
 *             .resourceGroupName("examplerg")
 *             .topicSpaceName("exampleTopicSpaceName1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PermissionBinding examplePermissionBindingName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/permissionBindings/{permissionBindingName}
 * ```
 * @property clientGroupName The name of the client group resource that the permission is bound to.
 * The client group needs to be a resource under the same namespace the permission binding is a part of.
 * @property description Description for the Permission Binding resource.
 * @property namespaceName Name of the namespace.
 * @property permission The allowed permission.
 * @property permissionBindingName The permission binding name.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property topicSpaceName The name of the Topic Space resource that the permission is bound to.
 * The Topic space needs to be a resource under the same namespace the permission binding is a part of.
 */
public data class PermissionBindingArgs(
    public val clientGroupName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val permission: Output<Either<String, PermissionType>>? = null,
    public val permissionBindingName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val topicSpaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.PermissionBindingArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.PermissionBindingArgs =
        com.pulumi.azurenative.eventgrid.PermissionBindingArgs.builder()
            .clientGroupName(clientGroupName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .permission(
                permission?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .permissionBindingName(permissionBindingName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .topicSpaceName(topicSpaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionBindingArgs].
 */
@PulumiTagMarker
public class PermissionBindingArgsBuilder internal constructor() {
    private var clientGroupName: Output<String>? = null

    private var description: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var permission: Output<Either<String, PermissionType>>? = null

    private var permissionBindingName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var topicSpaceName: Output<String>? = null

    /**
     * @param value The name of the client group resource that the permission is bound to.
     * The client group needs to be a resource under the same namespace the permission binding is a part of.
     */
    @JvmName("udyauohdkkqdkdst")
    public suspend fun clientGroupName(`value`: Output<String>) {
        this.clientGroupName = value
    }

    /**
     * @param value Description for the Permission Binding resource.
     */
    @JvmName("sgqxwctyuliwiprk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("nmjpjwpbbforvwxc")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The allowed permission.
     */
    @JvmName("trebmfdmkqtlbepo")
    public suspend fun permission(`value`: Output<Either<String, PermissionType>>) {
        this.permission = value
    }

    /**
     * @param value The permission binding name.
     */
    @JvmName("upqxnwkrbxtyqlgd")
    public suspend fun permissionBindingName(`value`: Output<String>) {
        this.permissionBindingName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("oyihyjcflmmhrdqf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Topic Space resource that the permission is bound to.
     * The Topic space needs to be a resource under the same namespace the permission binding is a part of.
     */
    @JvmName("gtnvylpkqnlwkcmq")
    public suspend fun topicSpaceName(`value`: Output<String>) {
        this.topicSpaceName = value
    }

    /**
     * @param value The name of the client group resource that the permission is bound to.
     * The client group needs to be a resource under the same namespace the permission binding is a part of.
     */
    @JvmName("ndivfrxuyjquaaqi")
    public suspend fun clientGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientGroupName = mapped
    }

    /**
     * @param value Description for the Permission Binding resource.
     */
    @JvmName("hngkplkgpnpptlfp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("lkdqglivqxbrprgg")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The allowed permission.
     */
    @JvmName("hyxwopbuqlkjmlqf")
    public suspend fun permission(`value`: Either<String, PermissionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permission = mapped
    }

    /**
     * @param value The allowed permission.
     */
    @JvmName("exepprqjxymhreqt")
    public fun permission(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PermissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permission = mapped
    }

    /**
     * @param value The allowed permission.
     */
    @JvmName("mciisntonvdgfhvk")
    public fun permission(`value`: PermissionType) {
        val toBeMapped = Either.ofRight<String, PermissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permission = mapped
    }

    /**
     * @param value The permission binding name.
     */
    @JvmName("hbttikweofgvqgkj")
    public suspend fun permissionBindingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionBindingName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("cdbkniengdgvhwfv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Topic Space resource that the permission is bound to.
     * The Topic space needs to be a resource under the same namespace the permission binding is a part of.
     */
    @JvmName("gjmhxneetavelbar")
    public suspend fun topicSpaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicSpaceName = mapped
    }

    internal fun build(): PermissionBindingArgs = PermissionBindingArgs(
        clientGroupName = clientGroupName,
        description = description,
        namespaceName = namespaceName,
        permission = permission,
        permissionBindingName = permissionBindingName,
        resourceGroupName = resourceGroupName,
        topicSpaceName = topicSpaceName,
    )
}
