@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.TopicEventSubscriptionArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.EventDeliverySchema
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeadLetterWithResourceIdentityArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeadLetterWithResourceIdentityArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeliveryWithResourceIdentityArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeliveryWithResourceIdentityArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.EventSubscriptionFilterArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.EventSubscriptionFilterArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.RetryPolicyArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.RetryPolicyArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.StorageBlobDeadLetterDestinationArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.StorageBlobDeadLetterDestinationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Event Subscription
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### TopicEventSubscriptions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topicEventSubscription = new AzureNative.EventGrid.TopicEventSubscription("topicEventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.WebHookEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "WebHook",
 *             EndpointUrl = "https://requestb.in/15ksip71",
 *         },
 *         EventSubscriptionName = "exampleEventSubscriptionName1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         ResourceGroupName = "examplerg",
 *         TopicName = "exampleTopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewTopicEventSubscription(ctx, "topicEventSubscription", &eventgrid.TopicEventSubscriptionArgs{
 * 			Destination: eventgrid.WebHookEventSubscriptionDestination{
 * 				EndpointType: "WebHook",
 * 				EndpointUrl:  "https://requestb.in/15ksip71",
 * 			},
 * 			EventSubscriptionName: pulumi.String("exampleEventSubscriptionName1"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 				SubjectBeginsWith:      pulumi.String("ExamplePrefix"),
 * 				SubjectEndsWith:        pulumi.String("ExampleSuffix"),
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			TopicName:         pulumi.String("exampleTopic1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.TopicEventSubscription;
 * import com.pulumi.azurenative.eventgrid.TopicEventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topicEventSubscription = new TopicEventSubscription("topicEventSubscription", TopicEventSubscriptionArgs.builder()
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "WebHook"),
 *                 Map.entry("endpointUrl", "https://requestb.in/15ksip71")
 *             ))
 *             .eventSubscriptionName("exampleEventSubscriptionName1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .resourceGroupName("examplerg")
 *             .topicName("exampleTopic1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:TopicEventSubscription exampleEventSubscriptionName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}
 * ```
 * @property deadLetterDestination The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
 * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property deadLetterWithResourceIdentity The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
 * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property deliveryWithResourceIdentity Information about the destination where events have to be delivered for the event subscription.
 * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property destination Information about the destination where events have to be delivered for the event subscription.
 * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property eventDeliverySchema The event delivery schema for the event subscription.
 * @property eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
 * @property expirationTimeUtc Expiration time of the event subscription.
 * @property filter Information about the filter for the event subscription.
 * @property labels List of user defined labels.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property retryPolicy The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
 * @property topicName Name of the domain topic.
 */
public data class TopicEventSubscriptionArgs(
    public val deadLetterDestination: Output<StorageBlobDeadLetterDestinationArgs>? = null,
    public val deadLetterWithResourceIdentity: Output<DeadLetterWithResourceIdentityArgs>? = null,
    public val deliveryWithResourceIdentity: Output<DeliveryWithResourceIdentityArgs>? = null,
    public val destination: Output<Any>? = null,
    public val eventDeliverySchema: Output<Either<String, EventDeliverySchema>>? = null,
    public val eventSubscriptionName: Output<String>? = null,
    public val expirationTimeUtc: Output<String>? = null,
    public val filter: Output<EventSubscriptionFilterArgs>? = null,
    public val labels: Output<List<String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retryPolicy: Output<RetryPolicyArgs>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.TopicEventSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.TopicEventSubscriptionArgs =
        com.pulumi.azurenative.eventgrid.TopicEventSubscriptionArgs.builder()
            .deadLetterDestination(
                deadLetterDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deadLetterWithResourceIdentity(
                deadLetterWithResourceIdentity?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .deliveryWithResourceIdentity(
                deliveryWithResourceIdentity?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .destination(destination?.applyValue({ args0 -> args0 }))
            .eventDeliverySchema(
                eventDeliverySchema?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .eventSubscriptionName(eventSubscriptionName?.applyValue({ args0 -> args0 }))
            .expirationTimeUtc(expirationTimeUtc?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retryPolicy(retryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicEventSubscriptionArgs].
 */
@PulumiTagMarker
public class TopicEventSubscriptionArgsBuilder internal constructor() {
    private var deadLetterDestination: Output<StorageBlobDeadLetterDestinationArgs>? = null

    private var deadLetterWithResourceIdentity: Output<DeadLetterWithResourceIdentityArgs>? = null

    private var deliveryWithResourceIdentity: Output<DeliveryWithResourceIdentityArgs>? = null

    private var destination: Output<Any>? = null

    private var eventDeliverySchema: Output<Either<String, EventDeliverySchema>>? = null

    private var eventSubscriptionName: Output<String>? = null

    private var expirationTimeUtc: Output<String>? = null

    private var filter: Output<EventSubscriptionFilterArgs>? = null

    private var labels: Output<List<String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var retryPolicy: Output<RetryPolicyArgs>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("dyvolpqgnetkwnuu")
    public suspend fun deadLetterDestination(`value`: Output<StorageBlobDeadLetterDestinationArgs>) {
        this.deadLetterDestination = value
    }

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("wllfdxpawhelgrax")
    public suspend
    fun deadLetterWithResourceIdentity(`value`: Output<DeadLetterWithResourceIdentityArgs>) {
        this.deadLetterWithResourceIdentity = value
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("tsnfhnlnhihwvkfr")
    public suspend
    fun deliveryWithResourceIdentity(`value`: Output<DeliveryWithResourceIdentityArgs>) {
        this.deliveryWithResourceIdentity = value
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("obxgmfcvscyadxst")
    public suspend fun destination(`value`: Output<Any>) {
        this.destination = value
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("hqsmgleoyvhfpcdj")
    public suspend fun eventDeliverySchema(`value`: Output<Either<String, EventDeliverySchema>>) {
        this.eventDeliverySchema = value
    }

    /**
     * @param value Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("yiywuvumlkkpplat")
    public suspend fun eventSubscriptionName(`value`: Output<String>) {
        this.eventSubscriptionName = value
    }

    /**
     * @param value Expiration time of the event subscription.
     */
    @JvmName("yfngxbedeobmaedh")
    public suspend fun expirationTimeUtc(`value`: Output<String>) {
        this.expirationTimeUtc = value
    }

    /**
     * @param value Information about the filter for the event subscription.
     */
    @JvmName("qqtoiamewdebeigl")
    public suspend fun filter(`value`: Output<EventSubscriptionFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value List of user defined labels.
     */
    @JvmName("oapixmdcudkcilcq")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("apcocjjsgvrmfoje")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values List of user defined labels.
     */
    @JvmName("acmjwafypjdrqhxk")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("xsbaxsnapucuuntq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
     */
    @JvmName("iqdkocevovihsjiq")
    public suspend fun retryPolicy(`value`: Output<RetryPolicyArgs>) {
        this.retryPolicy = value
    }

    /**
     * @param value Name of the domain topic.
     */
    @JvmName("wambulptxucwprmh")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("fkiyafxxqynlnnwu")
    public suspend fun deadLetterDestination(`value`: StorageBlobDeadLetterDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterDestination = mapped
    }

    /**
     * @param argument The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("mnwfwhonausoawmt")
    public suspend
    fun deadLetterDestination(argument: suspend StorageBlobDeadLetterDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = StorageBlobDeadLetterDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deadLetterDestination = mapped
    }

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("ueatiktjvngprkfj")
    public suspend fun deadLetterWithResourceIdentity(`value`: DeadLetterWithResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterWithResourceIdentity = mapped
    }

    /**
     * @param argument The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("jdwvwllpeybxjpre")
    public suspend
    fun deadLetterWithResourceIdentity(argument: suspend DeadLetterWithResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = DeadLetterWithResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deadLetterWithResourceIdentity = mapped
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("cwqjewdwwreqtqjj")
    public suspend fun deliveryWithResourceIdentity(`value`: DeliveryWithResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryWithResourceIdentity = mapped
    }

    /**
     * @param argument Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("hukreqxtrcmahmmr")
    public suspend
    fun deliveryWithResourceIdentity(argument: suspend DeliveryWithResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = DeliveryWithResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryWithResourceIdentity = mapped
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("nmjnksgotkprxeyo")
    public suspend fun destination(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("jceigsrkmgxppndr")
    public suspend fun eventDeliverySchema(`value`: Either<String, EventDeliverySchema>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("mkkgwvtkomwajxym")
    public fun eventDeliverySchema(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventDeliverySchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("rqxwjlsbrhkmsbdv")
    public fun eventDeliverySchema(`value`: EventDeliverySchema) {
        val toBeMapped = Either.ofRight<String, EventDeliverySchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("tpwdxnhnxmilbwkw")
    public suspend fun eventSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value Expiration time of the event subscription.
     */
    @JvmName("mgcdemtiwdkmjeqf")
    public suspend fun expirationTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationTimeUtc = mapped
    }

    /**
     * @param value Information about the filter for the event subscription.
     */
    @JvmName("urhtraiqviqhtrlr")
    public suspend fun filter(`value`: EventSubscriptionFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Information about the filter for the event subscription.
     */
    @JvmName("emggyqgbdljjodnv")
    public suspend fun filter(argument: suspend EventSubscriptionFilterArgsBuilder.() -> Unit) {
        val toBeMapped = EventSubscriptionFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value List of user defined labels.
     */
    @JvmName("lojyjitqxplqrrjp")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values List of user defined labels.
     */
    @JvmName("bmlungstwtqcloet")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("ltapvmcllrodgecq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
     */
    @JvmName("tvjjquntteudpsqo")
    public suspend fun retryPolicy(`value`: RetryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryPolicy = mapped
    }

    /**
     * @param argument The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
     */
    @JvmName("wlhubtwowdqiugkd")
    public suspend fun retryPolicy(argument: suspend RetryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RetryPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retryPolicy = mapped
    }

    /**
     * @param value Name of the domain topic.
     */
    @JvmName("pbeuehffijyhvlpo")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): TopicEventSubscriptionArgs = TopicEventSubscriptionArgs(
        deadLetterDestination = deadLetterDestination,
        deadLetterWithResourceIdentity = deadLetterWithResourceIdentity,
        deliveryWithResourceIdentity = deliveryWithResourceIdentity,
        destination = destination,
        eventDeliverySchema = eventDeliverySchema,
        eventSubscriptionName = eventSubscriptionName,
        expirationTimeUtc = expirationTimeUtc,
        filter = filter,
        labels = labels,
        resourceGroupName = resourceGroupName,
        retryPolicy = retryPolicy,
        topicName = topicName,
    )
}
