@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates if the client is enabled or not. Default value is Enabled.
 */
public enum class ClientState(
    public val javaValue: com.pulumi.azurenative.eventgrid.enums.ClientState,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.enums.ClientState> {
    Enabled(com.pulumi.azurenative.eventgrid.enums.ClientState.Enabled),
    Disabled(com.pulumi.azurenative.eventgrid.enums.ClientState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.eventgrid.enums.ClientState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.enums.ClientState): ClientState =
            ClientState.values().first { it.javaValue == javaType }
    }
}
