@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.ClientAuthenticationSettingsArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.AlternativeAuthenticationNameSource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Client authentication settings for namespace resource.
 * @property alternativeAuthenticationNameSources Alternative authentication name sources related to client authentication settings for namespace resource.
 */
public data class ClientAuthenticationSettingsArgs(
    public val alternativeAuthenticationNameSources:
    Output<List<Either<String, AlternativeAuthenticationNameSource>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.ClientAuthenticationSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.ClientAuthenticationSettingsArgs =
        com.pulumi.azurenative.eventgrid.inputs.ClientAuthenticationSettingsArgs.builder()
            .alternativeAuthenticationNameSources(
                alternativeAuthenticationNameSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClientAuthenticationSettingsArgs].
 */
@PulumiTagMarker
public class ClientAuthenticationSettingsArgsBuilder internal constructor() {
    private var alternativeAuthenticationNameSources:
        Output<List<Either<String, AlternativeAuthenticationNameSource>>>? = null

    /**
     * @param value Alternative authentication name sources related to client authentication settings for namespace resource.
     */
    @JvmName("yreduwxwskgpenma")
    public suspend
    fun alternativeAuthenticationNameSources(`value`: Output<List<Either<String, AlternativeAuthenticationNameSource>>>) {
        this.alternativeAuthenticationNameSources = value
    }

    @JvmName("tixexenwrtwnfcwf")
    public suspend fun alternativeAuthenticationNameSources(
        vararg
        values: Output<Either<String, AlternativeAuthenticationNameSource>>,
    ) {
        this.alternativeAuthenticationNameSources = Output.all(values.asList())
    }

    /**
     * @param values Alternative authentication name sources related to client authentication settings for namespace resource.
     */
    @JvmName("hrpwbfcrauoicjjl")
    public suspend
    fun alternativeAuthenticationNameSources(values: List<Output<Either<String, AlternativeAuthenticationNameSource>>>) {
        this.alternativeAuthenticationNameSources = Output.all(values)
    }

    /**
     * @param value Alternative authentication name sources related to client authentication settings for namespace resource.
     */
    @JvmName("ovutjwhmpckslfgx")
    public suspend
    fun alternativeAuthenticationNameSources(`value`: List<Either<String, AlternativeAuthenticationNameSource>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternativeAuthenticationNameSources = mapped
    }

    /**
     * @param values Alternative authentication name sources related to client authentication settings for namespace resource.
     */
    @JvmName("iuagxpesjfgvjmkg")
    public suspend fun alternativeAuthenticationNameSources(
        vararg
        values: Either<String, AlternativeAuthenticationNameSource>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alternativeAuthenticationNameSources = mapped
    }

    internal fun build(): ClientAuthenticationSettingsArgs = ClientAuthenticationSettingsArgs(
        alternativeAuthenticationNameSources = alternativeAuthenticationNameSources,
    )
}
