@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetClientPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientName Name of the client.
 * @property namespaceName Name of the namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetClientPlainArgs(
    public val clientName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetClientPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetClientPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetClientPlainArgs.builder()
            .clientName(clientName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClientPlainArgs].
 */
@PulumiTagMarker
public class GetClientPlainArgsBuilder internal constructor() {
    private var clientName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the client.
     */
    @JvmName("yasgwsgomcynmgob")
    public suspend fun clientName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clientName = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("vvjuxpghyittmnkt")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("mtatajruqbkikwxl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetClientPlainArgs = GetClientPlainArgs(
        clientName = clientName ?: throw PulumiNullFieldException("clientName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
