@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetEventSubscriptionDeliveryAttributesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventSubscriptionName Name of the event subscription.
 * @property scope The scope of the event subscription. The scope can be a subscription, or a resource group, or a top level resource belonging to a resource provider namespace, or an EventGrid topic. For example, use '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}' for a resource, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for an EventGrid topic.
 */
public data class GetEventSubscriptionDeliveryAttributesPlainArgs(
    public val eventSubscriptionName: String,
    public val scope: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetEventSubscriptionDeliveryAttributesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.GetEventSubscriptionDeliveryAttributesPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetEventSubscriptionDeliveryAttributesPlainArgs.builder()
            .eventSubscriptionName(eventSubscriptionName.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEventSubscriptionDeliveryAttributesPlainArgs].
 */
@PulumiTagMarker
public class GetEventSubscriptionDeliveryAttributesPlainArgsBuilder internal constructor() {
    private var eventSubscriptionName: String? = null

    private var scope: String? = null

    /**
     * @param value Name of the event subscription.
     */
    @JvmName("sfanicbtplwignvn")
    public suspend fun eventSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value The scope of the event subscription. The scope can be a subscription, or a resource group, or a top level resource belonging to a resource provider namespace, or an EventGrid topic. For example, use '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}' for a resource, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for an EventGrid topic.
     */
    @JvmName("okixjmlmgahbymcw")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetEventSubscriptionDeliveryAttributesPlainArgs =
        GetEventSubscriptionDeliveryAttributesPlainArgs(
            eventSubscriptionName = eventSubscriptionName ?: throw
                PulumiNullFieldException("eventSubscriptionName"),
            scope = scope ?: throw PulumiNullFieldException("scope"),
        )
}
