@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetPartnerRegistrationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property partnerRegistrationName Name of the partner registration.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetPartnerRegistrationPlainArgs(
    public val partnerRegistrationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetPartnerRegistrationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetPartnerRegistrationPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetPartnerRegistrationPlainArgs.builder()
            .partnerRegistrationName(partnerRegistrationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPartnerRegistrationPlainArgs].
 */
@PulumiTagMarker
public class GetPartnerRegistrationPlainArgsBuilder internal constructor() {
    private var partnerRegistrationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the partner registration.
     */
    @JvmName("atoorhkvqsbxqvtl")
    public suspend fun partnerRegistrationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.partnerRegistrationName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("tdluknvguadltwwx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPartnerRegistrationPlainArgs = GetPartnerRegistrationPlainArgs(
        partnerRegistrationName = partnerRegistrationName ?: throw
            PulumiNullFieldException("partnerRegistrationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
