@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
 * @property partnerTopicName Name of the partner topic.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs(
    public val eventSubscriptionName: String,
    public val partnerTopicName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs.builder()
            .eventSubscriptionName(eventSubscriptionName.let({ args0 -> args0 }))
            .partnerTopicName(partnerTopicName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs].
 */
@PulumiTagMarker
public class GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder internal
constructor() {
    private var eventSubscriptionName: String? = null

    private var partnerTopicName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("njvkmhlptjyotsqf")
    public suspend fun eventSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value Name of the partner topic.
     */
    @JvmName("jukplembhkpdilid")
    public suspend fun partnerTopicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.partnerTopicName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("opbcgfaffvbfajcn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs =
        GetPartnerTopicEventSubscriptionDeliveryAttributesPlainArgs(
            eventSubscriptionName = eventSubscriptionName ?: throw
                PulumiNullFieldException("eventSubscriptionName"),
            partnerTopicName = partnerTopicName ?: throw PulumiNullFieldException("partnerTopicName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
