@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetSystemTopicEventSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property systemTopicName Name of the system topic.
 */
public data class GetSystemTopicEventSubscriptionPlainArgs(
    public val eventSubscriptionName: String,
    public val resourceGroupName: String,
    public val systemTopicName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetSystemTopicEventSubscriptionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.GetSystemTopicEventSubscriptionPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetSystemTopicEventSubscriptionPlainArgs.builder()
            .eventSubscriptionName(eventSubscriptionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .systemTopicName(systemTopicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSystemTopicEventSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetSystemTopicEventSubscriptionPlainArgsBuilder internal constructor() {
    private var eventSubscriptionName: String? = null

    private var resourceGroupName: String? = null

    private var systemTopicName: String? = null

    /**
     * @param value Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("jqkqclrwswyumvwu")
    public suspend fun eventSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("cevnpvmkipwqyfot")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the system topic.
     */
    @JvmName("hjrelykchksnpjum")
    public suspend fun systemTopicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.systemTopicName = mapped
    }

    internal fun build(): GetSystemTopicEventSubscriptionPlainArgs =
        GetSystemTopicEventSubscriptionPlainArgs(
            eventSubscriptionName = eventSubscriptionName ?: throw
                PulumiNullFieldException("eventSubscriptionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            systemTopicName = systemTopicName ?: throw PulumiNullFieldException("systemTopicName"),
        )
}
