@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.IsNullOrUndefinedFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IsNullOrUndefined Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'IsNullOrUndefined'.
 */
public data class IsNullOrUndefinedFilterArgs(
    public val key: Output<String>? = null,
    public val operatorType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.IsNullOrUndefinedFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.IsNullOrUndefinedFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.IsNullOrUndefinedFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .operatorType(operatorType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IsNullOrUndefinedFilterArgs].
 */
@PulumiTagMarker
public class IsNullOrUndefinedFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var operatorType: Output<String>? = null

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("pjuvedhipqsyxlow")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'IsNullOrUndefined'.
     */
    @JvmName("jerwntgesapqmpne")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("vgfnxvjoxqxgkhdy")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'IsNullOrUndefined'.
     */
    @JvmName("oqebexsdhjnoapjs")
    public suspend fun operatorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    internal fun build(): IsNullOrUndefinedFilterArgs = IsNullOrUndefinedFilterArgs(
        key = key,
        operatorType = operatorType ?: throw PulumiNullFieldException("operatorType"),
    )
}
