@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.ListDomainSharedAccessKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName Name of the domain.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class ListDomainSharedAccessKeysPlainArgs(
    public val domainName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.ListDomainSharedAccessKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.ListDomainSharedAccessKeysPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.ListDomainSharedAccessKeysPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListDomainSharedAccessKeysPlainArgs].
 */
@PulumiTagMarker
public class ListDomainSharedAccessKeysPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the domain.
     */
    @JvmName("hybtqymevxckibww")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("hbyxjigtbcddbdbk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListDomainSharedAccessKeysPlainArgs = ListDomainSharedAccessKeysPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
