@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.ListTopicSharedAccessKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property topicName Name of the topic.
 */
public data class ListTopicSharedAccessKeysPlainArgs(
    public val resourceGroupName: String,
    public val topicName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.ListTopicSharedAccessKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.ListTopicSharedAccessKeysPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.ListTopicSharedAccessKeysPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicName(topicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListTopicSharedAccessKeysPlainArgs].
 */
@PulumiTagMarker
public class ListTopicSharedAccessKeysPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var topicName: String? = null

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("luqulcfcjqkwpyqx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the topic.
     */
    @JvmName("meppgccecgidbarx")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): ListTopicSharedAccessKeysPlainArgs = ListTopicSharedAccessKeysPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        topicName = topicName ?: throw PulumiNullFieldException("topicName"),
    )
}
