@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.PartnerAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The partner authorization details.
 * @property authorizedPartnersList The list of authorized partners.
 * @property defaultMaximumExpirationTimeInDays Time used to validate the authorization expiration time for each authorized partner. If DefaultMaximumExpirationTimeInDays is
 * not specified, the default is 7 days. Otherwise, allowed values are between 1 and 365 days.
 */
public data class PartnerAuthorizationArgs(
    public val authorizedPartnersList: Output<List<PartnerArgs>>? = null,
    public val defaultMaximumExpirationTimeInDays: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.PartnerAuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.PartnerAuthorizationArgs =
        com.pulumi.azurenative.eventgrid.inputs.PartnerAuthorizationArgs.builder()
            .authorizedPartnersList(
                authorizedPartnersList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .defaultMaximumExpirationTimeInDays(
                defaultMaximumExpirationTimeInDays?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [PartnerAuthorizationArgs].
 */
@PulumiTagMarker
public class PartnerAuthorizationArgsBuilder internal constructor() {
    private var authorizedPartnersList: Output<List<PartnerArgs>>? = null

    private var defaultMaximumExpirationTimeInDays: Output<Int>? = null

    /**
     * @param value The list of authorized partners.
     */
    @JvmName("pmvabaovacbihaew")
    public suspend fun authorizedPartnersList(`value`: Output<List<PartnerArgs>>) {
        this.authorizedPartnersList = value
    }

    @JvmName("lpmgbjaggcexqlnu")
    public suspend fun authorizedPartnersList(vararg values: Output<PartnerArgs>) {
        this.authorizedPartnersList = Output.all(values.asList())
    }

    /**
     * @param values The list of authorized partners.
     */
    @JvmName("awnwxlspgqbfphpw")
    public suspend fun authorizedPartnersList(values: List<Output<PartnerArgs>>) {
        this.authorizedPartnersList = Output.all(values)
    }

    /**
     * @param value Time used to validate the authorization expiration time for each authorized partner. If DefaultMaximumExpirationTimeInDays is
     * not specified, the default is 7 days. Otherwise, allowed values are between 1 and 365 days.
     */
    @JvmName("lwrpuxeifkxbdfhd")
    public suspend fun defaultMaximumExpirationTimeInDays(`value`: Output<Int>) {
        this.defaultMaximumExpirationTimeInDays = value
    }

    /**
     * @param value The list of authorized partners.
     */
    @JvmName("evvrshawtqtbchbj")
    public suspend fun authorizedPartnersList(`value`: List<PartnerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizedPartnersList = mapped
    }

    /**
     * @param argument The list of authorized partners.
     */
    @JvmName("ccraaluaokqykcui")
    public suspend fun authorizedPartnersList(argument: List<suspend PartnerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PartnerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.authorizedPartnersList = mapped
    }

    /**
     * @param argument The list of authorized partners.
     */
    @JvmName("epefqucdvnirxlyt")
    public suspend fun authorizedPartnersList(
        vararg
        argument: suspend PartnerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { PartnerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.authorizedPartnersList = mapped
    }

    /**
     * @param argument The list of authorized partners.
     */
    @JvmName("riqikepuolccxrou")
    public suspend fun authorizedPartnersList(argument: suspend PartnerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PartnerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.authorizedPartnersList = mapped
    }

    /**
     * @param values The list of authorized partners.
     */
    @JvmName("gxhaxkpeapctyqca")
    public suspend fun authorizedPartnersList(vararg values: PartnerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizedPartnersList = mapped
    }

    /**
     * @param value Time used to validate the authorization expiration time for each authorized partner. If DefaultMaximumExpirationTimeInDays is
     * not specified, the default is 7 days. Otherwise, allowed values are between 1 and 365 days.
     */
    @JvmName("vuuqkkinprruxdfo")
    public suspend fun defaultMaximumExpirationTimeInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultMaximumExpirationTimeInDays = mapped
    }

    internal fun build(): PartnerAuthorizationArgs = PartnerAuthorizationArgs(
        authorizedPartnersList = authorizedPartnersList,
        defaultMaximumExpirationTimeInDays = defaultMaximumExpirationTimeInDays,
    )
}
