@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.QueueInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of the Queue info for event subscription.
 * @property deadLetterDestinationWithResourceIdentity The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
 * Uses the managed identity setup on the parent resource (namely, topic) to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property eventTimeToLive Time span duration in ISO 8601 format that determines how long messages are available to the subscription from the time the message was published.
 * This duration value is expressed using the following format: \'P(n)Y(n)M(n)DT(n)H(n)M(n)S\', where:
 *     - (n) is replaced by the value of each time element that follows the (n).
 *     - P is the duration (or Period) designator and is always placed at the beginning of the duration.
 *     - Y is the year designator, and it follows the value for the number of years.
 *     - M is the month designator, and it follows the value for the number of months.
 *     - W is the week designator, and it follows the value for the number of weeks.
 *     - D is the day designator, and it follows the value for the number of days.
 *     - T is the time designator, and it precedes the time components.
 *     - H is the hour designator, and it follows the value for the number of hours.
 *     - M is the minute designator, and it follows the value for the number of minutes.
 *     - S is the second designator, and it follows the value for the number of seconds.
 * This duration value cannot be set greater than the topic’s EventRetentionInDays. It is is an optional field where its minimum value is 1 minute, and its maximum is determined
 * by topic’s EventRetentionInDays value. The followings are examples of valid values:
 *     - \'P0DT23H12M\' or \'PT23H12M\': for duration of 23 hours and 12 minutes.
 *     - \'P1D\' or \'P1DT0H0M0S\': for duration of 1 day.
 * @property maxDeliveryCount The maximum delivery count of the events.
 * @property receiveLockDurationInSeconds Maximum period in seconds in which once the message is in received (by the client) state and waiting to be accepted, released or rejected.
 * If this time elapsed after a message has been received by the client and not transitioned into accepted (not processed), released or rejected,
 * the message is available for redelivery. This is an optional field, where default is 60 seconds, minimum is 60 seconds and maximum is 300 seconds.
 */
public data class QueueInfoArgs(
    public val deadLetterDestinationWithResourceIdentity: Output<DeadLetterWithResourceIdentityArgs>? =
        null,
    public val eventTimeToLive: Output<String>? = null,
    public val maxDeliveryCount: Output<Int>? = null,
    public val receiveLockDurationInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.QueueInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.QueueInfoArgs =
        com.pulumi.azurenative.eventgrid.inputs.QueueInfoArgs.builder()
            .deadLetterDestinationWithResourceIdentity(
                deadLetterDestinationWithResourceIdentity?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .eventTimeToLive(eventTimeToLive?.applyValue({ args0 -> args0 }))
            .maxDeliveryCount(maxDeliveryCount?.applyValue({ args0 -> args0 }))
            .receiveLockDurationInSeconds(receiveLockDurationInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueueInfoArgs].
 */
@PulumiTagMarker
public class QueueInfoArgsBuilder internal constructor() {
    private var deadLetterDestinationWithResourceIdentity: Output<DeadLetterWithResourceIdentityArgs>? =
        null

    private var eventTimeToLive: Output<String>? = null

    private var maxDeliveryCount: Output<Int>? = null

    private var receiveLockDurationInSeconds: Output<Int>? = null

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("pcpyptbqfqmmgscn")
    public suspend
    fun deadLetterDestinationWithResourceIdentity(`value`: Output<DeadLetterWithResourceIdentityArgs>) {
        this.deadLetterDestinationWithResourceIdentity = value
    }

    /**
     * @param value Time span duration in ISO 8601 format that determines how long messages are available to the subscription from the time the message was published.
     * This duration value is expressed using the following format: \'P(n)Y(n)M(n)DT(n)H(n)M(n)S\', where:
     *     - (n) is replaced by the value of each time element that follows the (n).
     *     - P is the duration (or Period) designator and is always placed at the beginning of the duration.
     *     - Y is the year designator, and it follows the value for the number of years.
     *     - M is the month designator, and it follows the value for the number of months.
     *     - W is the week designator, and it follows the value for the number of weeks.
     *     - D is the day designator, and it follows the value for the number of days.
     *     - T is the time designator, and it precedes the time components.
     *     - H is the hour designator, and it follows the value for the number of hours.
     *     - M is the minute designator, and it follows the value for the number of minutes.
     *     - S is the second designator, and it follows the value for the number of seconds.
     * This duration value cannot be set greater than the topic’s EventRetentionInDays. It is is an optional field where its minimum value is 1 minute, and its maximum is determined
     * by topic’s EventRetentionInDays value. The followings are examples of valid values:
     *     - \'P0DT23H12M\' or \'PT23H12M\': for duration of 23 hours and 12 minutes.
     *     - \'P1D\' or \'P1DT0H0M0S\': for duration of 1 day.
     */
    @JvmName("gynflbiytvrqucnc")
    public suspend fun eventTimeToLive(`value`: Output<String>) {
        this.eventTimeToLive = value
    }

    /**
     * @param value The maximum delivery count of the events.
     */
    @JvmName("qpwiorltcmttjaum")
    public suspend fun maxDeliveryCount(`value`: Output<Int>) {
        this.maxDeliveryCount = value
    }

    /**
     * @param value Maximum period in seconds in which once the message is in received (by the client) state and waiting to be accepted, released or rejected.
     * If this time elapsed after a message has been received by the client and not transitioned into accepted (not processed), released or rejected,
     * the message is available for redelivery. This is an optional field, where default is 60 seconds, minimum is 60 seconds and maximum is 300 seconds.
     */
    @JvmName("vekghflctwxxjayi")
    public suspend fun receiveLockDurationInSeconds(`value`: Output<Int>) {
        this.receiveLockDurationInSeconds = value
    }

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("rvfwqqagjicmyxdk")
    public suspend
    fun deadLetterDestinationWithResourceIdentity(`value`: DeadLetterWithResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterDestinationWithResourceIdentity = mapped
    }

    /**
     * @param argument The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("jvelgtyxlftsshlb")
    public suspend
    fun deadLetterDestinationWithResourceIdentity(argument: suspend DeadLetterWithResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = DeadLetterWithResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deadLetterDestinationWithResourceIdentity = mapped
    }

    /**
     * @param value Time span duration in ISO 8601 format that determines how long messages are available to the subscription from the time the message was published.
     * This duration value is expressed using the following format: \'P(n)Y(n)M(n)DT(n)H(n)M(n)S\', where:
     *     - (n) is replaced by the value of each time element that follows the (n).
     *     - P is the duration (or Period) designator and is always placed at the beginning of the duration.
     *     - Y is the year designator, and it follows the value for the number of years.
     *     - M is the month designator, and it follows the value for the number of months.
     *     - W is the week designator, and it follows the value for the number of weeks.
     *     - D is the day designator, and it follows the value for the number of days.
     *     - T is the time designator, and it precedes the time components.
     *     - H is the hour designator, and it follows the value for the number of hours.
     *     - M is the minute designator, and it follows the value for the number of minutes.
     *     - S is the second designator, and it follows the value for the number of seconds.
     * This duration value cannot be set greater than the topic’s EventRetentionInDays. It is is an optional field where its minimum value is 1 minute, and its maximum is determined
     * by topic’s EventRetentionInDays value. The followings are examples of valid values:
     *     - \'P0DT23H12M\' or \'PT23H12M\': for duration of 23 hours and 12 minutes.
     *     - \'P1D\' or \'P1DT0H0M0S\': for duration of 1 day.
     */
    @JvmName("uxxofemkxmghjwxp")
    public suspend fun eventTimeToLive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventTimeToLive = mapped
    }

    /**
     * @param value The maximum delivery count of the events.
     */
    @JvmName("yyjhmwvagwnoncig")
    public suspend fun maxDeliveryCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDeliveryCount = mapped
    }

    /**
     * @param value Maximum period in seconds in which once the message is in received (by the client) state and waiting to be accepted, released or rejected.
     * If this time elapsed after a message has been received by the client and not transitioned into accepted (not processed), released or rejected,
     * the message is available for redelivery. This is an optional field, where default is 60 seconds, minimum is 60 seconds and maximum is 300 seconds.
     */
    @JvmName("boenitqbuwgakfvj")
    public suspend fun receiveLockDurationInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiveLockDurationInSeconds = mapped
    }

    internal fun build(): QueueInfoArgs = QueueInfoArgs(
        deadLetterDestinationWithResourceIdentity = deadLetterDestinationWithResourceIdentity,
        eventTimeToLive = eventTimeToLive,
        maxDeliveryCount = maxDeliveryCount,
        receiveLockDurationInSeconds = receiveLockDurationInSeconds,
    )
}
