@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.StorageBlobDeadLetterDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about the storage blob based dead letter destination.
 * @property blobContainerName The name of the Storage blob container that is the destination of the deadletter events
 * @property endpointType Type of the endpoint for the dead letter destination
 * Expected value is 'StorageBlob'.
 * @property resourceId The Azure Resource ID of the storage account that is the destination of the deadletter events
 */
public data class StorageBlobDeadLetterDestinationArgs(
    public val blobContainerName: Output<String>? = null,
    public val endpointType: Output<String>,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.StorageBlobDeadLetterDestinationArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.StorageBlobDeadLetterDestinationArgs =
        com.pulumi.azurenative.eventgrid.inputs.StorageBlobDeadLetterDestinationArgs.builder()
            .blobContainerName(blobContainerName?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageBlobDeadLetterDestinationArgs].
 */
@PulumiTagMarker
public class StorageBlobDeadLetterDestinationArgsBuilder internal constructor() {
    private var blobContainerName: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value The name of the Storage blob container that is the destination of the deadletter events
     */
    @JvmName("saauhghdcjeogmlj")
    public suspend fun blobContainerName(`value`: Output<String>) {
        this.blobContainerName = value
    }

    /**
     * @param value Type of the endpoint for the dead letter destination
     * Expected value is 'StorageBlob'.
     */
    @JvmName("oovjajotaueposuf")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The Azure Resource ID of the storage account that is the destination of the deadletter events
     */
    @JvmName("vwobnbgbmlbrfkvg")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The name of the Storage blob container that is the destination of the deadletter events
     */
    @JvmName("sglbbteykvuewomg")
    public suspend fun blobContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobContainerName = mapped
    }

    /**
     * @param value Type of the endpoint for the dead letter destination
     * Expected value is 'StorageBlob'.
     */
    @JvmName("djbqsoydiqewbyyv")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The Azure Resource ID of the storage account that is the destination of the deadletter events
     */
    @JvmName("sauspowfsfevbssl")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): StorageBlobDeadLetterDestinationArgs = StorageBlobDeadLetterDestinationArgs(
        blobContainerName = blobContainerName,
        endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
        resourceId = resourceId,
    )
}
