@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.StringNotContainsAdvancedFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * StringNotContains Advanced Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'StringNotContains'.
 * @property values The set of filter values.
 */
public data class StringNotContainsAdvancedFilterArgs(
    public val key: Output<String>? = null,
    public val operatorType: Output<String>,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.StringNotContainsAdvancedFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.StringNotContainsAdvancedFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.StringNotContainsAdvancedFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .operatorType(operatorType.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [StringNotContainsAdvancedFilterArgs].
 */
@PulumiTagMarker
public class StringNotContainsAdvancedFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var operatorType: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("yjaxuvvxlrwgtegh")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'StringNotContains'.
     */
    @JvmName("kklbldkuwddsrjxf")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("nkuurtubeilhcyqg")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("ktfpstxtyltbflts")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("roudspkbuyfqucup")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("wnwhsuneouaslbai")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'StringNotContains'.
     */
    @JvmName("jnpbhlonwmmylyjj")
    public suspend fun operatorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("sccrgnomnsvnnilo")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("ksqlfgsghddqqgup")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): StringNotContainsAdvancedFilterArgs = StringNotContainsAdvancedFilterArgs(
        key = key,
        operatorType = operatorType ?: throw PulumiNullFieldException("operatorType"),
        values = values,
    )
}
