@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.StringNotEndsWithAdvancedFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * StringNotEndsWith Advanced Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'StringNotEndsWith'.
 * @property values The set of filter values.
 */
public data class StringNotEndsWithAdvancedFilterArgs(
    public val key: Output<String>? = null,
    public val operatorType: Output<String>,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.StringNotEndsWithAdvancedFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.StringNotEndsWithAdvancedFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.StringNotEndsWithAdvancedFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .operatorType(operatorType.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [StringNotEndsWithAdvancedFilterArgs].
 */
@PulumiTagMarker
public class StringNotEndsWithAdvancedFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var operatorType: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("tytywivepjednfpk")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'StringNotEndsWith'.
     */
    @JvmName("pdftbrejbjuqygoh")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("jjgaijplhgdphrfg")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("hnxgekunwekyrpmt")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("ocnskptgldfoocsa")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("cscptqqnjuvcjrgb")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'StringNotEndsWith'.
     */
    @JvmName("xykiacsecuyfvtuf")
    public suspend fun operatorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("qyulifnqahqtmsbc")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("bietysefwlcfqrvv")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): StringNotEndsWithAdvancedFilterArgs = StringNotEndsWithAdvancedFilterArgs(
        key = key,
        operatorType = operatorType ?: throw PulumiNullFieldException("operatorType"),
        values = values,
    )
}
