@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * BoolEquals Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'BoolEquals'.
 * @property value The boolean filter value.
 */
public data class BoolEqualsFilterResponse(
    public val key: String? = null,
    public val operatorType: String,
    public val `value`: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.BoolEqualsFilterResponse):
            BoolEqualsFilterResponse = BoolEqualsFilterResponse(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            operatorType = javaType.operatorType(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
