@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Suppress

/**
 * Information about the deadletter destination with resource identity.
 * @property deadLetterDestination Information about the destination where events have to be delivered for the event subscription.
 * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property identity The identity to use when dead-lettering events.
 */
public data class DeadLetterWithResourceIdentityResponse(
    public val deadLetterDestination: StorageBlobDeadLetterDestinationResponse? = null,
    public val identity: EventSubscriptionIdentityResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.DeadLetterWithResourceIdentityResponse):
            DeadLetterWithResourceIdentityResponse = DeadLetterWithResourceIdentityResponse(
            deadLetterDestination = javaType.deadLetterDestination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.StorageBlobDeadLetterDestinationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.EventSubscriptionIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
