@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Dynamic delivery attribute mapping details.
 * @property name Name of the delivery attribute or header.
 * @property sourceField JSON path in the event which contains attribute value.
 * @property type Type of the delivery attribute or header name.
 * Expected value is 'Dynamic'.
 */
public data class DynamicDeliveryAttributeMappingResponse(
    public val name: String? = null,
    public val sourceField: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.DynamicDeliveryAttributeMappingResponse):
            DynamicDeliveryAttributeMappingResponse = DynamicDeliveryAttributeMappingResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            sourceField = javaType.sourceField().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
