@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * EventGrid Domain.
 * @property autoCreateTopicWithFirstSubscription This Boolean is used to specify the creation mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
 * In this context, creation of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
 * When this property is null or set to true, Event Grid is responsible of automatically creating the domain topic when the first event subscription is
 * created at the scope of the domain topic. If this property is set to false, then creating the first event subscription will require creating a domain topic
 * by the user. The self-management mode can be used if the user wants full control of when the domain topic is created, while auto-managed mode provides the
 * flexibility to perform less operations and manage fewer resources by the user. Also, note that in auto-managed creation mode, user is allowed to create the
 * domain topic on demand if needed.
 * @property autoDeleteTopicWithLastSubscription This Boolean is used to specify the deletion mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
 * In this context, deletion of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
 * When this property is set to true, Event Grid is responsible of automatically deleting the domain topic when the last event subscription at the scope
 * of the domain topic is deleted. If this property is set to false, then the user needs to manually delete the domain topic when it is no longer needed
 * (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The self-management mode can be used if the user wants full
 * control of when the domain topic needs to be deleted, while auto-managed mode provides the flexibility to perform less operations and manage fewer
 * resources by the user.
 * @property dataResidencyBoundary Data Residency Boundary of the resource.
 * @property disableLocalAuth This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the domain.
 * @property endpoint Endpoint for the Event Grid Domain Resource which is used for publishing the events.
 * @property id Fully qualified identifier of the resource.
 * @property identity Identity information for the Event Grid Domain resource.
 * @property inboundIpRules This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
 * @property inputSchema This determines the format that Event Grid should expect for incoming events published to the Event Grid Domain Resource.
 * @property inputSchemaMapping Information about the InputSchemaMapping which specified the info about mapping event payload.
 * @property location Location of the resource.
 * @property metricResourceId Metric resource id for the Event Grid Domain Resource.
 * @property name Name of the resource.
 * @property privateEndpointConnections List of private endpoint connections.
 * @property provisioningState Provisioning state of the Event Grid Domain Resource.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules" />
 * @property systemData The system metadata relating to the Event Grid Domain resource.
 * @property tags Tags of the resource.
 * @property type Type of the resource.
 */
public data class GetDomainResult(
    public val autoCreateTopicWithFirstSubscription: Boolean? = null,
    public val autoDeleteTopicWithLastSubscription: Boolean? = null,
    public val dataResidencyBoundary: String? = null,
    public val disableLocalAuth: Boolean? = null,
    public val endpoint: String,
    public val id: String,
    public val identity: IdentityInfoResponse? = null,
    public val inboundIpRules: List<InboundIpRuleResponse>? = null,
    public val inputSchema: String? = null,
    public val inputSchemaMapping: JsonInputSchemaMappingResponse? = null,
    public val location: String,
    public val metricResourceId: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetDomainResult):
            GetDomainResult = GetDomainResult(
            autoCreateTopicWithFirstSubscription = javaType.autoCreateTopicWithFirstSubscription().map({ args0 ->
                args0
            }).orElse(null),
            autoDeleteTopicWithLastSubscription = javaType.autoDeleteTopicWithLastSubscription().map({ args0 ->
                args0
            }).orElse(null),
            dataResidencyBoundary = javaType.dataResidencyBoundary().map({ args0 -> args0 }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inboundIpRules = javaType.inboundIpRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.InboundIpRuleResponse.Companion.toKotlin(args0)
                })
            }),
            inputSchema = javaType.inputSchema().map({ args0 -> args0 }).orElse(null),
            inputSchemaMapping = javaType.inputSchemaMapping().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonInputSchemaMappingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            metricResourceId = javaType.metricResourceId(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
