@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * This enables publishing to Event Grid using a custom input schema. This can be used to map properties from a custom input JSON schema to the Event Grid event schema.
 * @property dataVersion The mapping information for the DataVersion property of the Event Grid Event.
 * @property eventTime The mapping information for the EventTime property of the Event Grid Event.
 * @property eventType The mapping information for the EventType property of the Event Grid Event.
 * @property id The mapping information for the Id property of the Event Grid Event.
 * @property inputSchemaMappingType Type of the custom mapping
 * Expected value is 'Json'.
 * @property subject The mapping information for the Subject property of the Event Grid Event.
 * @property topic The mapping information for the Topic property of the Event Grid Event.
 */
public data class JsonInputSchemaMappingResponse(
    public val dataVersion: JsonFieldWithDefaultResponse? = null,
    public val eventTime: JsonFieldResponse? = null,
    public val eventType: JsonFieldWithDefaultResponse? = null,
    public val id: JsonFieldResponse? = null,
    public val inputSchemaMappingType: String,
    public val subject: JsonFieldWithDefaultResponse? = null,
    public val topic: JsonFieldResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.JsonInputSchemaMappingResponse):
            JsonInputSchemaMappingResponse = JsonInputSchemaMappingResponse(
            dataVersion = javaType.dataVersion().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonFieldWithDefaultResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventTime = javaType.eventTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonFieldResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventType = javaType.eventType().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonFieldWithDefaultResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonFieldResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inputSchemaMappingType = javaType.inputSchemaMappingType(),
            subject = javaType.subject().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonFieldWithDefaultResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            topic = javaType.topic().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonFieldResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
