@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Shared access keys of the partner namespace.
 * @property key1 Shared access key1 for the partner namespace.
 * @property key2 Shared access key2 for the partner namespace.
 */
public data class ListPartnerNamespaceSharedAccessKeysResult(
    public val key1: String? = null,
    public val key2: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.ListPartnerNamespaceSharedAccessKeysResult):
            ListPartnerNamespaceSharedAccessKeysResult = ListPartnerNamespaceSharedAccessKeysResult(
            key1 = javaType.key1().map({ args0 -> args0 }).orElse(null),
            key2 = javaType.key2().map({ args0 -> args0 }).orElse(null),
        )
    }
}
