@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.ApplicationGroupArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.inputs.ThrottlingPolicyArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.ThrottlingPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Application Group object
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-01-01-preview, 2024-01-01.
 * ## Example Usage
 * ### ApplicationGroupCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationGroup = new AzureNative.EventHub.ApplicationGroup("applicationGroup", new()
 *     {
 *         ApplicationGroupName = "appGroup1",
 *         ClientAppGroupIdentifier = "SASKeyName=KeyName",
 *         IsEnabled = true,
 *         NamespaceName = "contoso-ua-test-eh-system-1",
 *         Policies = new[]
 *         {
 *             {
 *                 { "metricId", "IncomingMessages" },
 *                 { "name", "ThrottlingPolicy1" },
 *                 { "rateLimitThreshold", 7912 },
 *                 { "type", "ThrottlingPolicy" },
 *             },
 *             {
 *                 { "metricId", "IncomingBytes" },
 *                 { "name", "ThrottlingPolicy2" },
 *                 { "rateLimitThreshold", 3951729 },
 *                 { "type", "ThrottlingPolicy" },
 *             },
 *             {
 *                 { "metricId", "OutgoingBytes" },
 *                 { "name", "ThrottlingPolicy3" },
 *                 { "rateLimitThreshold", 245175 },
 *                 { "type", "ThrottlingPolicy" },
 *             },
 *         },
 *         ResourceGroupName = "contosotest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewApplicationGroup(ctx, "applicationGroup", &eventhub.ApplicationGroupArgs{
 * 			ApplicationGroupName:     pulumi.String("appGroup1"),
 * 			ClientAppGroupIdentifier: pulumi.String("SASKeyName=KeyName"),
 * 			IsEnabled:                pulumi.Bool(true),
 * 			NamespaceName:            pulumi.String("contoso-ua-test-eh-system-1"),
 * 			Policies: []eventhub.ThrottlingPolicyArgs{
 * 				{
 * 					MetricId:           pulumi.String("IncomingMessages"),
 * 					Name:               pulumi.String("ThrottlingPolicy1"),
 * 					RateLimitThreshold: pulumi.Float64(7912),
 * 					Type:               pulumi.String("ThrottlingPolicy"),
 * 				},
 * 				{
 * 					MetricId:           pulumi.String("IncomingBytes"),
 * 					Name:               pulumi.String("ThrottlingPolicy2"),
 * 					RateLimitThreshold: pulumi.Float64(3951729),
 * 					Type:               pulumi.String("ThrottlingPolicy"),
 * 				},
 * 				{
 * 					MetricId:           pulumi.String("OutgoingBytes"),
 * 					Name:               pulumi.String("ThrottlingPolicy3"),
 * 					RateLimitThreshold: pulumi.Float64(245175),
 * 					Type:               pulumi.String("ThrottlingPolicy"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("contosotest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.ApplicationGroup;
 * import com.pulumi.azurenative.eventhub.ApplicationGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationGroup = new ApplicationGroup("applicationGroup", ApplicationGroupArgs.builder()
 *             .applicationGroupName("appGroup1")
 *             .clientAppGroupIdentifier("SASKeyName=KeyName")
 *             .isEnabled(true)
 *             .namespaceName("contoso-ua-test-eh-system-1")
 *             .policies(
 *                 Map.ofEntries(
 *                     Map.entry("metricId", "IncomingMessages"),
 *                     Map.entry("name", "ThrottlingPolicy1"),
 *                     Map.entry("rateLimitThreshold", 7912),
 *                     Map.entry("type", "ThrottlingPolicy")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("metricId", "IncomingBytes"),
 *                     Map.entry("name", "ThrottlingPolicy2"),
 *                     Map.entry("rateLimitThreshold", 3951729),
 *                     Map.entry("type", "ThrottlingPolicy")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("metricId", "OutgoingBytes"),
 *                     Map.entry("name", "ThrottlingPolicy3"),
 *                     Map.entry("rateLimitThreshold", 245175),
 *                     Map.entry("type", "ThrottlingPolicy")
 *                 ))
 *             .resourceGroupName("contosotest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:ApplicationGroup appGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/applicationGroups/{applicationGroupName}
 * ```
 * @property applicationGroupName The Application Group name
 * @property clientAppGroupIdentifier The Unique identifier for application group.Supports SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid)
 * @property isEnabled Determines if Application Group is allowed to create connection with namespace or not. Once the isEnabled is set to false, all the existing connections of application group gets dropped and no new connections will be allowed
 * @property namespaceName The Namespace name
 * @property policies List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.
 * @property resourceGroupName Name of the resource group within the azure subscription.
 */
public data class ApplicationGroupArgs(
    public val applicationGroupName: Output<String>? = null,
    public val clientAppGroupIdentifier: Output<String>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val namespaceName: Output<String>? = null,
    public val policies: Output<List<ThrottlingPolicyArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.ApplicationGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.ApplicationGroupArgs =
        com.pulumi.azurenative.eventhub.ApplicationGroupArgs.builder()
            .applicationGroupName(applicationGroupName?.applyValue({ args0 -> args0 }))
            .clientAppGroupIdentifier(clientAppGroupIdentifier?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .policies(
                policies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGroupArgs].
 */
@PulumiTagMarker
public class ApplicationGroupArgsBuilder internal constructor() {
    private var applicationGroupName: Output<String>? = null

    private var clientAppGroupIdentifier: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var namespaceName: Output<String>? = null

    private var policies: Output<List<ThrottlingPolicyArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The Application Group name
     */
    @JvmName("nbimsyylmnnxlxpr")
    public suspend fun applicationGroupName(`value`: Output<String>) {
        this.applicationGroupName = value
    }

    /**
     * @param value The Unique identifier for application group.Supports SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid)
     */
    @JvmName("demaimdujugxieqc")
    public suspend fun clientAppGroupIdentifier(`value`: Output<String>) {
        this.clientAppGroupIdentifier = value
    }

    /**
     * @param value Determines if Application Group is allowed to create connection with namespace or not. Once the isEnabled is set to false, all the existing connections of application group gets dropped and no new connections will be allowed
     */
    @JvmName("gtayyvpsngsuxixg")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("uhkuqskjkjamfekk")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.
     */
    @JvmName("awmdlmnahcysafur")
    public suspend fun policies(`value`: Output<List<ThrottlingPolicyArgs>>) {
        this.policies = value
    }

    @JvmName("junnjqcnbrrpeyav")
    public suspend fun policies(vararg values: Output<ThrottlingPolicyArgs>) {
        this.policies = Output.all(values.asList())
    }

    /**
     * @param values List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.
     */
    @JvmName("hdffghcjqphtfxef")
    public suspend fun policies(values: List<Output<ThrottlingPolicyArgs>>) {
        this.policies = Output.all(values)
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("hcllkpbcsafqotnx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Application Group name
     */
    @JvmName("rpvpvjxiymmjfxos")
    public suspend fun applicationGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGroupName = mapped
    }

    /**
     * @param value The Unique identifier for application group.Supports SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid)
     */
    @JvmName("dkoeqxnlmgcjflih")
    public suspend fun clientAppGroupIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAppGroupIdentifier = mapped
    }

    /**
     * @param value Determines if Application Group is allowed to create connection with namespace or not. Once the isEnabled is set to false, all the existing connections of application group gets dropped and no new connections will be allowed
     */
    @JvmName("tdlxvvsetklbhagj")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("xurhssjpmttgjrkf")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.
     */
    @JvmName("uhivdayiadtuwnig")
    public suspend fun policies(`value`: List<ThrottlingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param argument List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.
     */
    @JvmName("tqehdqdunypvxgxo")
    public suspend fun policies(argument: List<suspend ThrottlingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThrottlingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policies = mapped
    }

    /**
     * @param argument List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.
     */
    @JvmName("hichnklabyrsjvvd")
    public suspend fun policies(vararg argument: suspend ThrottlingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ThrottlingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policies = mapped
    }

    /**
     * @param argument List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.
     */
    @JvmName("dyhiosxlknmnpatv")
    public suspend fun policies(argument: suspend ThrottlingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ThrottlingPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.policies = mapped
    }

    /**
     * @param values List of group policies that define the behavior of application group. The policies can support resource governance scenarios such as limiting ingress or egress traffic.
     */
    @JvmName("hhptaghvvtjtxytl")
    public suspend fun policies(vararg values: ThrottlingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("tryusefilsiepdfl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ApplicationGroupArgs = ApplicationGroupArgs(
        applicationGroupName = applicationGroupName,
        clientAppGroupIdentifier = clientAppGroupIdentifier,
        isEnabled = isEnabled,
        namespaceName = namespaceName,
        policies = policies,
        resourceGroupName = resourceGroupName,
    )
}
