@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.NamespaceVirtualNetworkRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Single item in a List or Get VirtualNetworkRules operation
 * Azure REST API version: 2018-01-01-preview. Prior API version in Azure Native 1.x: 2018-01-01-preview.
 * ## Example Usage
 * ### NameSpaceVirtualNetworkRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceVirtualNetworkRule = new AzureNative.EventHub.NamespaceVirtualNetworkRule("namespaceVirtualNetworkRule", new()
 *     {
 *         NamespaceName = "sdk-Namespace-6019",
 *         ResourceGroupName = "ResourceGroup",
 *         VirtualNetworkRuleName = "sdk-VirtualNetworkRules-9191",
 *         VirtualNetworkSubnetId = "/subscriptions/Subscription/resourceGroups/sbehvnettest/providers/Microsoft.Network/virtualNetworks/sbehvnettest/subnets/default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewNamespaceVirtualNetworkRule(ctx, "namespaceVirtualNetworkRule", &eventhub.NamespaceVirtualNetworkRuleArgs{
 * 			NamespaceName:          pulumi.String("sdk-Namespace-6019"),
 * 			ResourceGroupName:      pulumi.String("ResourceGroup"),
 * 			VirtualNetworkRuleName: pulumi.String("sdk-VirtualNetworkRules-9191"),
 * 			VirtualNetworkSubnetId: pulumi.String("/subscriptions/Subscription/resourceGroups/sbehvnettest/providers/Microsoft.Network/virtualNetworks/sbehvnettest/subnets/default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.NamespaceVirtualNetworkRule;
 * import com.pulumi.azurenative.eventhub.NamespaceVirtualNetworkRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceVirtualNetworkRule = new NamespaceVirtualNetworkRule("namespaceVirtualNetworkRule", NamespaceVirtualNetworkRuleArgs.builder()
 *             .namespaceName("sdk-Namespace-6019")
 *             .resourceGroupName("ResourceGroup")
 *             .virtualNetworkRuleName("sdk-VirtualNetworkRules-9191")
 *             .virtualNetworkSubnetId("/subscriptions/Subscription/resourceGroups/sbehvnettest/providers/Microsoft.Network/virtualNetworks/sbehvnettest/subnets/default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:NamespaceVirtualNetworkRule sdk-VirtualNetworkRules-9191 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/virtualnetworkrules/{virtualNetworkRuleName}
 * ```
 * @property namespaceName The Namespace name
 * @property resourceGroupName Name of the resource group within the azure subscription.
 * @property virtualNetworkRuleName The Virtual Network Rule name.
 * @property virtualNetworkSubnetId ARM ID of Virtual Network Subnet
 */
public data class NamespaceVirtualNetworkRuleArgs(
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val virtualNetworkRuleName: Output<String>? = null,
    public val virtualNetworkSubnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.NamespaceVirtualNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.NamespaceVirtualNetworkRuleArgs =
        com.pulumi.azurenative.eventhub.NamespaceVirtualNetworkRuleArgs.builder()
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .virtualNetworkRuleName(virtualNetworkRuleName?.applyValue({ args0 -> args0 }))
            .virtualNetworkSubnetId(virtualNetworkSubnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceVirtualNetworkRuleArgs].
 */
@PulumiTagMarker
public class NamespaceVirtualNetworkRuleArgsBuilder internal constructor() {
    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var virtualNetworkRuleName: Output<String>? = null

    private var virtualNetworkSubnetId: Output<String>? = null

    /**
     * @param value The Namespace name
     */
    @JvmName("whvmvsygljuaytgp")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("mwkrfnawtusmgpfc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Virtual Network Rule name.
     */
    @JvmName("gatvmdvfvqglryxm")
    public suspend fun virtualNetworkRuleName(`value`: Output<String>) {
        this.virtualNetworkRuleName = value
    }

    /**
     * @param value ARM ID of Virtual Network Subnet
     */
    @JvmName("xdotxxfswjssnkir")
    public suspend fun virtualNetworkSubnetId(`value`: Output<String>) {
        this.virtualNetworkSubnetId = value
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("mjusshcyvndkqbdr")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("mgxyrwogfwdrlukn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Virtual Network Rule name.
     */
    @JvmName("mrypthkgnygnwelb")
    public suspend fun virtualNetworkRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRuleName = mapped
    }

    /**
     * @param value ARM ID of Virtual Network Subnet
     */
    @JvmName("swgohbtbgxysdlvl")
    public suspend fun virtualNetworkSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkSubnetId = mapped
    }

    internal fun build(): NamespaceVirtualNetworkRuleArgs = NamespaceVirtualNetworkRuleArgs(
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
        virtualNetworkRuleName = virtualNetworkRuleName,
        virtualNetworkSubnetId = virtualNetworkSubnetId,
    )
}
