@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.CaptureDescriptionArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.EncodingCaptureDescription
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties to configure capture description for eventhub
 * @property destination Properties of Destination where capture will be stored. (Storage Account, Blob Names)
 * @property enabled A value that indicates whether capture description is enabled.
 * @property encoding Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in New API Version
 * @property intervalInSeconds The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between 60 to 900 seconds
 * @property sizeLimitInBytes The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between 10485760 to 524288000 bytes
 * @property skipEmptyArchives A value that indicates whether to Skip Empty Archives
 */
public data class CaptureDescriptionArgs(
    public val destination: Output<DestinationArgs>? = null,
    public val enabled: Output<Boolean>? = null,
    public val encoding: Output<EncodingCaptureDescription>? = null,
    public val intervalInSeconds: Output<Int>? = null,
    public val sizeLimitInBytes: Output<Int>? = null,
    public val skipEmptyArchives: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.CaptureDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.CaptureDescriptionArgs =
        com.pulumi.azurenative.eventhub.inputs.CaptureDescriptionArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .encoding(encoding?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .intervalInSeconds(intervalInSeconds?.applyValue({ args0 -> args0 }))
            .sizeLimitInBytes(sizeLimitInBytes?.applyValue({ args0 -> args0 }))
            .skipEmptyArchives(skipEmptyArchives?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CaptureDescriptionArgs].
 */
@PulumiTagMarker
public class CaptureDescriptionArgsBuilder internal constructor() {
    private var destination: Output<DestinationArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var encoding: Output<EncodingCaptureDescription>? = null

    private var intervalInSeconds: Output<Int>? = null

    private var sizeLimitInBytes: Output<Int>? = null

    private var skipEmptyArchives: Output<Boolean>? = null

    /**
     * @param value Properties of Destination where capture will be stored. (Storage Account, Blob Names)
     */
    @JvmName("pfrgbjjkvcscborw")
    public suspend fun destination(`value`: Output<DestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value A value that indicates whether capture description is enabled.
     */
    @JvmName("vjigpwxcioqjgbfm")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in New API Version
     */
    @JvmName("dcmawxdelxrgoypw")
    public suspend fun encoding(`value`: Output<EncodingCaptureDescription>) {
        this.encoding = value
    }

    /**
     * @param value The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between 60 to 900 seconds
     */
    @JvmName("xhoxkfscrxucwgcy")
    public suspend fun intervalInSeconds(`value`: Output<Int>) {
        this.intervalInSeconds = value
    }

    /**
     * @param value The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between 10485760 to 524288000 bytes
     */
    @JvmName("putmpoyyrolwvkje")
    public suspend fun sizeLimitInBytes(`value`: Output<Int>) {
        this.sizeLimitInBytes = value
    }

    /**
     * @param value A value that indicates whether to Skip Empty Archives
     */
    @JvmName("tmuoxcdqcpkpvill")
    public suspend fun skipEmptyArchives(`value`: Output<Boolean>) {
        this.skipEmptyArchives = value
    }

    /**
     * @param value Properties of Destination where capture will be stored. (Storage Account, Blob Names)
     */
    @JvmName("bsbnjywkhqsjomgr")
    public suspend fun destination(`value`: DestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Properties of Destination where capture will be stored. (Storage Account, Blob Names)
     */
    @JvmName("qqympxyrbigcqmdu")
    public suspend fun destination(argument: suspend DestinationArgsBuilder.() -> Unit) {
        val toBeMapped = DestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value A value that indicates whether capture description is enabled.
     */
    @JvmName("iytynfadcekvujum")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in New API Version
     */
    @JvmName("mqmjydfbanwhftkn")
    public suspend fun encoding(`value`: EncodingCaptureDescription?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between 60 to 900 seconds
     */
    @JvmName("nkygltjvikregehl")
    public suspend fun intervalInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalInSeconds = mapped
    }

    /**
     * @param value The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between 10485760 to 524288000 bytes
     */
    @JvmName("yykgqbvutbcenojp")
    public suspend fun sizeLimitInBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeLimitInBytes = mapped
    }

    /**
     * @param value A value that indicates whether to Skip Empty Archives
     */
    @JvmName("ltbgmyttbpklmepe")
    public suspend fun skipEmptyArchives(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipEmptyArchives = mapped
    }

    internal fun build(): CaptureDescriptionArgs = CaptureDescriptionArgs(
        destination = destination,
        enabled = enabled,
        encoding = encoding,
        intervalInSeconds = intervalInSeconds,
        sizeLimitInBytes = sizeLimitInBytes,
        skipEmptyArchives = skipEmptyArchives,
    )
}
