@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName The Namespace name
 * @property privateEndpointConnectionName The PrivateEndpointConnection name
 * @property resourceGroupName Name of the resource group within the azure subscription.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val namespaceName: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventhub.inputs.GetPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.eventhub.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Namespace name
     */
    @JvmName("toxcsaitoolpsyoe")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The PrivateEndpointConnection name
     */
    @JvmName("micvnkaukossdtmb")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("cnlmleldctkuacfe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
