@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of host the Custom Locations is referencing (Kubernetes, etc...).
 */
public enum class HostType(
    public val javaValue: com.pulumi.azurenative.extendedlocation.enums.HostType,
) : ConvertibleToJava<com.pulumi.azurenative.extendedlocation.enums.HostType> {
    Kubernetes(com.pulumi.azurenative.extendedlocation.enums.HostType.Kubernetes),
    ;

    override fun toJava(): com.pulumi.azurenative.extendedlocation.enums.HostType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.extendedlocation.enums.HostType): HostType =
            HostType.values().first { it.javaValue == javaType }
    }
}
