@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin.inputs

import com.pulumi.azurenative.extendedlocation.inputs.CustomLocationPropertiesAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This is optional input that contains the authentication that should be used to generate the namespace.
 * @property type The type of the Custom Locations authentication
 * @property value The kubeconfig value.
 */
public data class CustomLocationPropertiesAuthenticationArgs(
    public val type: Output<String>? = null,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.extendedlocation.inputs.CustomLocationPropertiesAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.extendedlocation.inputs.CustomLocationPropertiesAuthenticationArgs =
        com.pulumi.azurenative.extendedlocation.inputs.CustomLocationPropertiesAuthenticationArgs.builder()
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomLocationPropertiesAuthenticationArgs].
 */
@PulumiTagMarker
public class CustomLocationPropertiesAuthenticationArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The type of the Custom Locations authentication
     */
    @JvmName("mmhqjbweoyecjjtj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The kubeconfig value.
     */
    @JvmName("xygqwtiqcojgyifh")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The type of the Custom Locations authentication
     */
    @JvmName("vmgvolfpwvtxnesh")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The kubeconfig value.
     */
    @JvmName("vmecepnipqlxsnyb")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): CustomLocationPropertiesAuthenticationArgs =
        CustomLocationPropertiesAuthenticationArgs(
            type = type,
            `value` = `value`,
        )
}
