@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.features.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Authorization Profile
 * @property approvedTime The approved time
 * @property approver The approver
 * @property requestedTime The requested time
 * @property requester The requester
 * @property requesterObjectId The requester object id
 */
public data class AuthorizationProfileResponse(
    public val approvedTime: String,
    public val approver: String,
    public val requestedTime: String,
    public val requester: String,
    public val requesterObjectId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.features.outputs.AuthorizationProfileResponse):
            AuthorizationProfileResponse = AuthorizationProfileResponse(
            approvedTime = javaType.approvedTime(),
            approver = javaType.approver(),
            requestedTime = javaType.requestedTime(),
            requester = javaType.requester(),
            requesterObjectId = javaType.requesterObjectId(),
        )
    }
}
